/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.subtasks;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

@WebSudoRequired
public class ManageSubTasks
extends JiraWebActionSupport {
    private final SubTaskManager subTaskManager;
    private final TranslationManager translationManager;
    private String id;
    private String name;
    private String description;
    private String iconurl = "/images/icons/issuetypes/subtask_alternate.png";

    public ManageSubTasks(SubTaskManager subTaskManager, TranslationManager translationManager) {
        this.subTaskManager = subTaskManager;
        this.translationManager = translationManager;
    }

    @RequiresXsrfCheck
    public String doEnableSubTasks() throws Exception {
        if (this.isSubTasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.already.enabled"));
            return this.getResult();
        }
        this.subTaskManager.enableSubTasks();
        return this.getRedirect(this.getActionName() + ".jspa");
    }

    public boolean isSubTasksEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public Collection getSubTasksIssueTypes() {
        return this.subTaskManager.getSubTaskIssueTypeObjects();
    }

    public String doAddNewSubTaskIssueType() {
        if (!this.isSubTasksEnabled()) {
            return this.returnCompleteWithInlineRedirect(this.getActionName() + ".jspa");
        }
        return "input";
    }

    @RequiresXsrfCheck
    public String doAddSubTaskIssueType() throws Exception {
        this.validateAddInput();
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.subTaskManager.createSubTaskIssueType(this.getName(), Long.valueOf(this.getSubTasksIssueTypes().size()), this.getDescription(), this.getIconurl());
            return this.returnCompleteWithInlineRedirect(this.getActionName() + ".jspa");
        }
        catch (CreateException e) {
            this.log.error((Object)"Error occurred while adding sub-task issue type.", (Throwable)e);
            this.addErrorMessage("Error occurred while adding sub-task issue type. Please see log for more details.");
            return "error";
        }
    }

    private void validateAddInput() {
        if (!this.isSubTasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.disabled"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.specify.a.name.for.this.new.sub.task.issue.type"));
        } else if (this.subTaskManager.issueTypeExistsByName(this.getName())) {
            this.addError("name", this.getText("admin.errors.issue.type.with.this.name.already.exists"));
        }
        if (!TextUtils.stringSet((String)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.must.specify.a.url.for.the.icon"));
        }
    }

    @RequiresXsrfCheck
    public String doMoveSubTaskIssueTypeUp() throws Exception {
        this.validateMoveInput();
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.subTaskManager.moveSubTaskIssueTypeUp(this.getId());
            return this.getRedirect(this.getActionName() + ".jspa");
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Error occurred while storing sub-task issue types.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.error.occured.while.storing.sub.task.issue"));
            return "error";
        }
    }

    @RequiresXsrfCheck
    public String doMoveSubTaskIssueTypeDown() throws Exception {
        this.validateMoveInput();
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.subTaskManager.moveSubTaskIssueTypeDown(this.getId());
            return this.getRedirect(this.getActionName() + ".jspa");
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Error occurred while storing sub-task issue types.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.error.occured.while.storing.sub.task.issue"));
            return "error";
        }
    }

    private void validateMoveInput() {
        if (!this.isSubTasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.are.disabled"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.no.subtask.issue.type.id.specified"));
        } else if (!this.subTaskManager.issueTypeExistsById(this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.no.subtask.issue.type.with.id.exists", "'" + this.getId() + "'"));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

