/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.comparison;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResults;
import com.atlassian.jira.scheme.distiller.SchemeDistiller;
import com.atlassian.jira.scheme.distiller.SchemeRelationships;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.web.action.admin.scheme.AbstractSchemeToolAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@WebSudoRequired
public class SchemeComparisonToolAction
extends AbstractSchemeToolAction {
    public static final String SCHEME_TOOL_NAME = "SchemeComparisonTool";
    private SchemeDistiller schemeDistiller;
    private DistilledSchemeResults distilledSchemeResults;

    public SchemeComparisonToolAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, SchemeDistiller schemeDistiller, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
        this.schemeDistiller = schemeDistiller;
    }

    public String doDefault() throws Exception {
        this.getDistilledSchemeResults();
        return "input";
    }

    public DistilledSchemeResults getDistilledSchemeResults() {
        List<Scheme> schemesToCompare;
        if (this.distilledSchemeResults == null && (schemesToCompare = this.getSchemeObjs()) != null) {
            this.distilledSchemeResults = this.schemeDistiller.distillSchemes(schemesToCompare);
        }
        return this.distilledSchemeResults;
    }

    public SchemeRelationships getSchemeRelationships() {
        return this.schemeDistiller.getSchemeRelationships(this.getDistilledSchemeResults());
    }

    public int getSchemeDifferencePercentage() {
        return (int)(this.getSchemeRelationships().getSchemeDifferencePercentage() * 100.0);
    }

    public String getSchemeComparisonDifference() {
        String differenceString = NumberFormat.getPercentInstance().format(this.getSchemeRelationships().getSchemeDifferencePercentage());
        if (this.getSchemeRelationships().getSchemeDifferencePercentage() == 0.0) {
            differenceString = differenceString + " (" + this.getText("admin.scheme.picker.comparison.identical") + ')';
        }
        return differenceString;
    }

    public List<String> getSchemeEntitiesByDisplayName(Collection<SchemeEntity> schemeEntities) {
        ArrayList<String> displayNames = new ArrayList<String>(schemeEntities.size());
        for (SchemeEntity schemeEntity : schemeEntities) {
            displayNames.add(this.getSchemeTypeForEntity(schemeEntity));
        }
        Collections.sort(displayNames);
        return displayNames;
    }

    public int getTotalDistilledFromSchemes() {
        int i = 0;
        for (Object o : this.distilledSchemeResults.getDistilledSchemeResults()) {
            DistilledSchemeResult distilledSchemeResult = (DistilledSchemeResult)o;
            i += distilledSchemeResult.getOriginalSchemes().size();
        }
        return i;
    }

    public String getSchemeTypeForEntity(SchemeEntity schemeEntity) {
        String displayName = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            NotificationType notificationType = this.getNotificationType(schemeEntity);
            displayName = this.formatDisplayNameAndArgument(notificationType, schemeEntity.getParameter());
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            SecurityType securityType = this.getSecurityType(schemeEntity);
            displayName = this.formatDisplayNameAndArgument(securityType, schemeEntity.getParameter());
        }
        return displayName;
    }

    private SecurityType getSecurityType(SchemeEntity schemeEntity) {
        return ((PermissionTypeManager)ComponentAccessor.getComponentOfType(PermissionTypeManager.class)).getSecurityType(schemeEntity.getType());
    }

    private NotificationType getNotificationType(SchemeEntity schemeEntity) {
        return ((NotificationTypeManager)ComponentAccessor.getComponentOfType(NotificationTypeManager.class)).getNotificationType(schemeEntity.getType());
    }

    private String formatDisplayNameAndArgument(NotificationType notificationType, String argument) {
        if (argument == null) {
            return notificationType.getDisplayName();
        }
        return notificationType.getDisplayName() + " (" + notificationType.getArgumentDisplay(argument) + ')';
    }

    private String formatDisplayNameAndArgument(SecurityType securityType, String argument) {
        if (argument == null) {
            return securityType.getDisplayName();
        }
        return securityType.getDisplayName() + " (" + securityType.getArgumentDisplay(argument) + ')';
    }

    public String getSchemeDisplayName() {
        String displayName = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.schemes.notifications.notifications");
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.common.words.permissions");
        }
        return displayName;
    }

    public String getComparisonToolDescription() {
        String displayName = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.scheme.comparsion.desc.1.notifications", "<br/>");
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.scheme.comparsion.desc.1.permissions", "<br/>");
        }
        return displayName;
    }

    public String getEditPage() {
        String editPage = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            editPage = "EditNotifications";
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            editPage = "EditPermissions";
        }
        return editPage;
    }

    public String getParameters() {
        StringBuilder params = new StringBuilder();
        params.append("?selectedSchemeType=");
        params.append(this.getSelectedSchemeType());
        return params.toString();
    }

    public String getColumnWidthPercentage() {
        Collection schemes = this.getSchemeRelationships().getSchemes();
        if (schemes != null) {
            return 100 / (schemes.size() + 1) + "%";
        }
        return "100%";
    }

    @Override
    public String getToolName() {
        return SCHEME_TOOL_NAME;
    }
}

