/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.web.action.admin.scheme.AbstractSchemeToolAction;
import com.atlassian.jira.web.component.schemepicker.SchemePickerWebComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractSchemePickerAction
extends AbstractSchemeToolAction {
    public static final String ASSOCIATED = "associated";
    public static final String ALL = "all";
    private String typeOfSchemesToDisplay;

    protected AbstractSchemePickerAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
    }

    public String doDefault() {
        this.typeOfSchemesToDisplay = ASSOCIATED;
        return "input";
    }

    protected void doValidation() {
        if (this.getSelectedSchemeIds() == null || this.getSelectedSchemeIds().length == 0) {
            this.addErrorMessage(this.getText("admin.scheme.picker.errpr.select.schemes"));
        }
    }

    protected String doExecute() throws Exception {
        StringBuilder redirectString = new StringBuilder(this.getRedirectPage());
        redirectString.append("?selectedSchemeType=");
        redirectString.append(this.getSelectedSchemeType());
        this.storeSelectedSchemeIdsInSession();
        return this.forceRedirect(redirectString.toString());
    }

    public String getSchemePickerWebComponentHtml() throws GenericEntityException {
        return new SchemePickerWebComponent(this.getSchemes(), this.getSchemeTypes(), this.getSelectedSchemeType(), this.getSelectedSchemeIds()).getHtml("SchemeGroupsToRoleTransformerAction");
    }

    public String doSwitch() {
        return "input";
    }

    public String getTypeOfSchemesToDisplay() {
        return this.typeOfSchemesToDisplay;
    }

    public void setTypeOfSchemesToDisplay(String typeOfSchemesToDisplay) {
        this.typeOfSchemesToDisplay = typeOfSchemesToDisplay;
    }

    public Map getSchemes() throws GenericEntityException {
        HashMap<String, List<Scheme>> schemes = new HashMap<String, List<Scheme>>();
        for (Object o : this.getSchemeTypes().values()) {
            String schemeType = (String)o;
            SchemeManager schemeManager = this.getSchemeManager(schemeType);
            if (ASSOCIATED.equals(this.getTypeOfSchemesToDisplay())) {
                schemes.put(schemeType, schemeManager.getAssociatedSchemes(false));
                continue;
            }
            if (!ALL.equals(this.getTypeOfSchemesToDisplay())) continue;
            schemes.put(schemeType, this.getSchemeFactory().getSchemes(schemeManager.getSchemes()));
        }
        return schemes;
    }

    public Map getSchemeTypes() {
        return EasyMap.build((Object)this.getText("admin.scheme.picker.notification.schemes.type"), (Object)"NotificationScheme", (Object)this.getText("admin.scheme.picker.permission.schemes.type"), (Object)"PermissionScheme");
    }

    public abstract String getRedirectPage();

    public int getMaxNumberOfSchemesToCompare() {
        try {
            return Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.schemes.comparison.max"));
        }
        catch (NumberFormatException t) {
            return 5;
        }
    }
}

