/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorComparator;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractRoleActorAction
extends JiraWebActionSupport {
    private Long projectRoleId;
    protected final ProjectRoleService projectRoleService;
    private final ProjectManager projectManager;
    private ProjectFactory projectFactory;
    protected RoleActorFactory roleActorFactory;
    private Long projectId;

    public AbstractRoleActorAction(ProjectRoleService projectRoleService, ProjectManager projectManager, ProjectFactory projectFactory, RoleActorFactory roleActorFactory) {
        this.projectRoleService = projectRoleService;
        this.projectManager = projectManager;
        this.projectFactory = projectFactory;
        this.roleActorFactory = roleActorFactory;
    }

    public Project getProject() {
        if (this.getProjectId() == null) {
            return null;
        }
        Project project = null;
        GenericValue projectGv = this.projectManager.getProject(this.getProjectId());
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public ProjectRole getProjectRole() {
        return this.projectRoleService.getProjectRole(this.projectRoleId, (ErrorCollection)this);
    }

    public void setProjectRoleId(Long projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    public Long getProjectRoleId() {
        return this.projectRoleId;
    }

    public Collection getRoleActors(ProjectRole projectRole) {
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(projectRole, this.getProject(), (ErrorCollection)this);
        if (projectRoleActors == null) {
            return Collections.EMPTY_LIST;
        }
        Set roleActors = projectRoleActors.getRoleActors();
        TreeSet<RoleActor> sortedRoleActors = new TreeSet<RoleActor>(RoleActorComparator.COMPARATOR);
        if (roleActors != null) {
            sortedRoleActors.addAll(roleActors);
        }
        return sortedRoleActors;
    }
}

