/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.notification;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.web.action.admin.notification.SchemeAwareNotificationAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

@WebSudoRequired
public class AddNotification
extends SchemeAwareNotificationAction {
    private String type;
    private Long[] eventTypeIds;
    private final EventTypeManager eventTypeManager;
    private final NotificationTypeManager notificationTypeManager;
    private final NotificationSchemeManager notificationSchemeManager;

    public AddNotification(EventTypeManager eventTypeManager, NotificationTypeManager notificationTypeManager, NotificationSchemeManager notificationSchemeManager) {
        this.eventTypeManager = eventTypeManager;
        this.notificationTypeManager = notificationTypeManager;
        this.notificationSchemeManager = notificationSchemeManager;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return ComponentAccessor.getNotificationSchemeManager();
    }

    @Override
    public String getRedirectURL() {
        return "EditNotifications!default.jspa?schemeId=";
    }

    protected void doValidation() {
        try {
            if (this.getSchemeId() == null || this.getScheme() == null) {
                this.addErrorMessage(this.getText("admin.errors.notifications.must.select.scheme"));
            }
            if (this.getEventTypeIds() == null || this.getEventTypeIds().length == 0) {
                this.addError("eventTypeIds", this.getText("admin.errors.notifications.must.select.notification.to.add"));
            }
            if (!TextUtils.stringSet((String)this.getType())) {
                this.addErrorMessage(this.getText("admin.errors.notifications.must.select.type"));
            } else if (!this.notificationTypeManager.getNotificationType(this.getType()).doValidation(this.getType(), this.getParameters())) {
                this.addErrorMessage(this.getText("admin.errors.notifications.fill.out.box"));
            }
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("admin.errors.notifications.error.occured", "\n") + e.getMessage());
        }
    }

    protected String doExecute() throws Exception {
        for (Long eventTypeId : this.eventTypeIds) {
            String displayValue = this.getParameter(this.getType());
            String rawValue = this.notificationTypeManager.getNotificationType(this.getType()).getArgumentValue(displayValue);
            SchemeEntity schemeEntity = new SchemeEntity(this.getType(), rawValue, (Object)eventTypeId, null);
            if (this.notificationSchemeManager.hasEntities(this.getScheme(), eventTypeId, this.type, rawValue, null)) continue;
            this.notificationSchemeManager.createSchemeEntity(this.getScheme(), schemeEntity);
        }
        return this.getRedirect(this.getRedirectURL() + this.getSchemeId());
    }

    public Map<String, NotificationType> getTypes() {
        return this.notificationTypeManager.getTypes();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map getParameters() {
        return ActionContext.getSingleValueParameters();
    }

    public String getParameter(String key) {
        return (String)this.getParameters().get(key);
    }

    public Map<Long, EventType> getEvents() {
        return this.eventTypeManager.getEventTypesMap();
    }

    public Long[] getEventTypeIds() {
        return this.eventTypeIds;
    }

    public void setEventTypeIds(Long[] eventTypeIds) {
        this.eventTypeIds = eventTypeIds;
    }
}

