/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditIssueType
extends AbstractEditConstant {
    private final IssueTypeManager issueTypeManager;

    public EditIssueType(IssueTypeManager issueTypeManager) {
        this.issueTypeManager = issueTypeManager;
    }

    @Override
    protected void doValidation() {
        if (StringUtils.isBlank((String)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.issuetypes.must.specify.url"));
        }
        if (StringUtils.length((String)this.name) > 60) {
            this.addError("name", this.getText("admin.errors.issuetypes.name.must.not.exceed.max.length"));
        }
        super.doValidation();
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getIssueType(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssueTypes.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getIssueTypes();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
    }

    @Override
    protected String createDuplicateMessage() {
        return this.getText("admin.errors.issue.type.with.this.name.already.exists");
    }

    @Override
    protected String doExecute() throws Exception {
        IssueType issueType = this.issueTypeManager.getIssueType(this.id);
        this.issueTypeManager.editIssueType(issueType, this.name, this.description, this.iconurl);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }
}

