/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class EditFieldScreen
extends AbstractFieldScreenAction {
    private final FieldScreenService fieldScreenService;
    private boolean edited;

    public EditFieldScreen(FieldScreenManager fieldScreenManager, FieldScreenService fieldScreenService) {
        super(fieldScreenManager);
        this.fieldScreenService = fieldScreenService;
    }

    public String doDefault() throws Exception {
        this.validateId();
        if (this.invalidInput()) {
            return "error";
        }
        this.setFieldScreenName(this.getFieldScreen().getName());
        this.setFieldScreenDescription(this.getFieldScreen().getDescription());
        return "input";
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateScreenName();
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getFieldScreen().setName(this.getFieldScreenName());
        this.getFieldScreen().setDescription(this.getFieldScreenDescription());
        this.getFieldScreen().store();
        return this.redirectToView();
    }

    public void setFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreen = fieldScreen;
    }

    @RequiresXsrfCheck
    public String doCopyFieldScreen() {
        this.validateId();
        ServiceOutcome result = this.fieldScreenService.copy(this.getFieldScreen(), this.getFieldScreenName(), this.getFieldScreenDescription(), this.getLoggedInApplicationUser());
        if (!result.isValid()) {
            this.addError("fieldScreenName", (String)result.getErrorCollection().getErrorMessages().iterator().next());
            return "error";
        }
        return this.redirectToView();
    }

    public String doViewCopyFieldScreen() {
        this.validateId();
        this.setFieldScreenName(this.getText("common.words.copyof", this.getFieldScreen().getName()));
        this.setFieldScreenDescription(this.getFieldScreen().getDescription());
        return "input";
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }
}

