/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.enterprise;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.web.action.AbstractViewIssueColumns;
import java.util.ArrayList;
import java.util.List;

public class ViewSearchRequestIssueColumns
extends AbstractViewIssueColumns {
    private Long filterId;
    private EditableSearchRequestColumnLayout editableSearchRequestColumnLayout;

    public ViewSearchRequestIssueColumns(IssueSearcherManager issueSearcherManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() != null && ComponentAccessor.getPermissionManager().hasPermission(1, this.getLoggedInUser())) {
            if (this.getFilterId() == null) {
                this.addErrorMessage(this.getText("admin.errors.no.filter.id.provided"));
                return this.getResult();
            }
            return this.runOperation();
        }
        return "securitybreach";
    }

    @Override
    protected String doRestoreDefault() {
        try {
            this.getColumnLayoutManager().restoreSearchRequestColumnLayout(this.getSearchRequest());
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.not.remove.column.layout"));
        }
        catch (DataAccessException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.net.retrieve.search", "'" + this.getFilterId() + "'"));
        }
        return this.getResult();
    }

    @Override
    protected void store() {
        try {
            this.getColumnLayoutManager().storeEditableSearchRequestColumnLayout(this.editableSearchRequestColumnLayout);
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)"The was an error storing the search request's column layout.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.not.store.column.layout"));
        }
    }

    @Override
    public String getActionLocation(String prefix) {
        return prefix + this.getActionName() + ".jspa";
    }

    @Override
    protected List<NavigableField> getAvailableNavigatableFields() throws FieldException {
        return new ArrayList<NavigableField>(this.getFieldManager().getAvailableNavigableFields(this.getLoggedInUser()));
    }

    @Override
    protected EditableColumnLayout getColumnLayout() {
        if (this.editableSearchRequestColumnLayout == null) {
            try {
                this.editableSearchRequestColumnLayout = this.getColumnLayoutManager().getEditableSearchRequestColumnLayout(this.getLoggedInUser(), this.getSearchRequest());
            }
            catch (ColumnLayoutStorageException e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.could.not.retrieve.column.layout"));
            }
            catch (DataAccessException e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.could.net.retrieve.search", "'" + this.getFilterId() + "'."));
            }
        }
        return this.editableSearchRequestColumnLayout;
    }

    @Override
    public String doShowActionsColumn() throws Exception {
        return "input";
    }

    @Override
    public String doHideActionsColumn() throws Exception {
        return "input";
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public boolean isUsingDefaultColumns() {
        try {
            return !this.getColumnLayoutManager().hasColumnLayout(this.getSearchRequest());
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.not.check.if.default.column.layout"));
            return true;
        }
        catch (DataAccessException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.net.retrieve.search", "'" + this.getFilterId() + "'."));
            return true;
        }
    }

    @Override
    public SearchRequest getSearchRequest() {
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getLoggedInUser());
        return ComponentManager.getInstance().getSearchRequestService().getFilter((JiraServiceContext)ctx, this.getFilterId());
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect(this.getActionName() + "!default.jspa?filterId=" + this.getFilterId());
    }
}

