/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.dashboards;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.admin.dashboards.AbstractDashboardAdministration;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class DeleteSharedDashboard
extends AbstractDashboardAdministration {
    private final UserPickerSearchService userPickerSearchService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final PortalPageService portalPageService;
    private final ShareTypeValidatorUtils shareTypeValidatorUtils;
    private final FavouritesService favouriteService;
    private Long otherFavouriteCount;
    private Collection subscriptions;
    private static final int DASHBOARDS_PER_PAGE = 20;

    public DeleteSharedDashboard(PermissionManager permissionManager, UserPickerSearchService userPickerSearchService, AvatarService avatarService, UserManager userManager, FavouritesService favouriteService, PortalPageService portalPageService, PortalPageManager portalPageManager, ShareTypeValidatorUtils shareTypeValidatorUtils) {
        super(permissionManager, portalPageManager);
        this.permissionManager = permissionManager;
        this.userPickerSearchService = userPickerSearchService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.portalPageService = portalPageService;
        this.shareTypeValidatorUtils = shareTypeValidatorUtils;
        this.favouriteService = favouriteService;
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (this.getDashboardId() != null) {
            JiraServiceContext ctx = this.getJiraServiceContext(this.getDashboardId());
            this.portalPageService.validateForDelete(ctx, this.getDashboardId());
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.portalPageService.deletePortalPage(this.getJiraServiceContext(this.getDashboardId()), this.getDashboardId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.dashboards.cannot.delete.dashboard"));
            return "error";
        }
        this.repaginateIfNeeded();
        this.setDashboard(null);
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private void repaginateIfNeeded() {
        int newResultCount;
        int pagingOffset = StringUtils.isNotBlank((String)this.getPagingOffset()) ? Integer.parseInt(this.getPagingOffset()) - 1 : -1;
        int n = newResultCount = StringUtils.isNotBlank((String)this.getTotalResultCount()) ? Integer.parseInt(this.getTotalResultCount()) - 1 : -1;
        if (pagingOffset >= 0) {
            this.setTotalResultCount("" + newResultCount);
            if (newResultCount % 20 == 0) {
                this.setPagingOffset("" + pagingOffset);
            }
        }
    }

    public int getOtherFavouriteCount() {
        if (this.otherFavouriteCount == null) {
            PortalPage dashboard = this.getDashboard();
            ApplicationUser dashboardOwner = dashboard.getOwner();
            boolean isFavourite = this.favouriteService.isFavourite(dashboardOwner, (SharedEntity)dashboard);
            int count = isFavourite ? dashboard.getFavouriteCount().intValue() - 1 : dashboard.getFavouriteCount().intValue();
            this.otherFavouriteCount = count;
        }
        return this.otherFavouriteCount.intValue();
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }
}

