/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.customfields.config.helper.BasicConfigDescriptor;
import com.atlassian.jira.issue.customfields.config.helper.BasicConfigFieldDescriptor;
import com.atlassian.jira.issue.customfields.config.helper.BasicConfigItemType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.admin.customfields.AbstractEditConfigurationItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditBasicConfig
extends AbstractEditConfigurationItemAction {
    private String className;
    private BasicConfigItemType configItemType;
    private BasicConfigDescriptor configDescriptor;
    private final GenericConfigManager genericConfigManager;
    private Map values;

    public EditBasicConfig(GenericConfigManager genericConfigManager, ManagedConfigurationItemService managedConfigurationItemService) {
        super(managedConfigurationItemService);
        this.genericConfigManager = genericConfigManager;
    }

    @Override
    public String doDefault() throws Exception {
        try {
            this.init();
            return super.doDefault();
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.unable.to.instantiate.class") + " " + this.className);
            return "error";
        }
    }

    protected void doValidation() {
        if (this.validateFieldLocked()) {
            return;
        }
    }

    protected String doExecute() throws Exception {
        this.init();
        Map actionParams = ActionContext.getParameters();
        HashMap<String, String> valuesToPersist = new HashMap<String, String>();
        if (actionParams != null && this.configDescriptor.getConfigFields() != null) {
            for (Object o : this.configDescriptor.getConfigFields()) {
                String objectKey;
                BasicConfigFieldDescriptor descriptor = (BasicConfigFieldDescriptor)o;
                String[] value = (String[])actionParams.get(objectKey = descriptor.getKey());
                valuesToPersist.put(objectKey, value != null && value.length > 0 ? value[0] : null);
            }
        }
        this.genericConfigManager.update(this.configItemType.getObjectKey(), this.getFieldConfigId().toString(), valuesToPersist);
        return this.getRedirect("ViewCustomFields.jspa");
    }

    public String getFieldValue(String key) {
        if (this.values == null) {
            this.values = (Map)this.configItemType.getConfigurationObject(null, this.getFieldConfig());
        }
        if (this.values != null) {
            return (String)this.values.get(key);
        }
        return null;
    }

    public String getTitle() {
        return this.configDescriptor.getTitle();
    }

    public String getInstructions() {
        return this.configDescriptor.getInstructions();
    }

    public List getConfigFields() {
        return this.configDescriptor.getConfigFields();
    }

    private void init() throws ClassNotFoundException {
        this.configItemType = (BasicConfigItemType)JiraUtils.loadComponent(this.className, EditBasicConfig.class);
        this.configDescriptor = this.configItemType.getBasicConfigDescriptor();
    }

    public BasicConfigDescriptor getConfigDescriptor() {
        return this.configDescriptor;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

