/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.setting.GzipCompression;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Locale;

@WebSudoRequired
public class ViewApplicationProperties
extends ProjectActionSupport {
    protected final UserPickerSearchService searchService;
    protected final LocaleManager localeManager;
    protected final TimeZoneService timeZoneService;
    protected final RendererManager rendererManager;
    private final PluginAccessor pluginAccessor;
    private final GzipCompression gZipCompression;
    private final IntroductionProperty introductionProperty;
    private final FeatureManager featureManager;
    private final JiraLicenseService jiraLicenseService;
    private boolean useGravatar;
    protected boolean criteriaAutoUpdate;

    public ViewApplicationProperties(UserPickerSearchService searchService, LocaleManager localeManager, TimeZoneService timeZoneService, RendererManager rendererManager, PluginAccessor pluginAccessor, GzipCompression gZipCompression, FeatureManager featureManager, IntroductionProperty introductionProperty, JiraLicenseService jiraLicenseService) {
        this.searchService = searchService;
        this.localeManager = localeManager;
        this.timeZoneService = timeZoneService;
        this.rendererManager = rendererManager;
        this.pluginAccessor = pluginAccessor;
        this.gZipCompression = gZipCompression;
        this.introductionProperty = introductionProperty;
        this.featureManager = featureManager;
        this.jiraLicenseService = jiraLicenseService;
        this.useGravatar = this.getApplicationProperties().getOption("jira.user.avatar.gravatar.enabled");
        this.criteriaAutoUpdate = this.getApplicationProperties().getOption("jira.issuenav.criteria.autoupdate");
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public String getJiraMode() {
        StringBuilder i18nString = new StringBuilder("admin.jira.mode.").append(this.getApplicationProperties().getString("jira.mode"));
        return this.getText(i18nString.toString());
    }

    public String getDisplayNameOfLocale(Locale locale) {
        return locale.getDisplayName(this.getLocale());
    }

    public boolean useSystemTimeZone() {
        return this.timeZoneService.useSystemTimeZone();
    }

    public TimeZoneInfo getDefaultTimeZoneInfo() {
        return this.timeZoneService.getDefaultTimeZoneInfo(this.getJiraServiceContext());
    }

    public boolean isUseGravatar() {
        return this.useGravatar;
    }

    public void setUseGravatar(boolean useGravatar) {
        this.useGravatar = useGravatar;
    }

    public String getContactAdministratorsMessage() {
        String message = this.getApplicationProperties().getDefaultBackedString("jira.contact.administrators.message");
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    public boolean getShowPluginHints() {
        return this.getApplicationProperties().getOption("show.plugin.marketing.hints");
    }

    public String getTacUrl() {
        return HelpUtil.getInstance().getHelpPath("application.properties.server.language.from.tac").getUrl();
    }

    public boolean isShowDisableCriteriaAutoUpdate() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin");
    }

    public boolean isCriteriaAutoUpdate() {
        return this.criteriaAutoUpdate;
    }

    public boolean isShowAdvertisingOption() {
        return this.featureManager.isOnDemand() && this.jiraLicenseService.getLicense().isEvaluation();
    }

    public GzipCompression getGzipCompression() {
        return this.gZipCompression;
    }

    public IntroductionProperty getIntroductionProperty() {
        return this.introductionProperty;
    }

    public boolean isBackgroundIndexingAvailable() {
        return true;
    }
}

