/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.mail.server.MailServerManager;
import javax.annotation.Nullable;

public class JiraContactHelperImpl
implements JiraContactHelper {
    static final String CONTACT_ADMINISTRATOR_KEY = "common.concepts.contact.administrator";
    static final String ADMINISTRATORS_LINK = "secure/ContactAdministrators!default.jspa";
    private final ApplicationProperties applicationProperties;
    private final MailServerManager mailServerManager;

    public JiraContactHelperImpl(ApplicationProperties applicationProperties, MailServerManager mailServerManager) {
        this.applicationProperties = applicationProperties;
        this.mailServerManager = mailServerManager;
    }

    public String getAdministratorContactLinkHtml(@Nullable String baseUrl, I18nHelper i18nHelper) {
        if (baseUrl == null || this.isContactFormTurnedOff()) {
            return this.getAdministratorContactMessage(i18nHelper);
        }
        String url = this.getAdministratorContactLink(baseUrl);
        String link = "<a href=\"" + url + "\">";
        String closeLink = "</a>";
        return i18nHelper.getText(CONTACT_ADMINISTRATOR_KEY, link, closeLink);
    }

    private boolean isContactFormTurnedOff() {
        return !this.applicationProperties.getOption("jira.show.contact.administrators.form");
    }

    public String getAdministratorContactMessage(I18nHelper i18nHelper) {
        return i18nHelper.getText(CONTACT_ADMINISTRATOR_KEY, "", "");
    }

    public boolean isAdministratorContactFormEnabled() {
        return this.mailServerManager.isDefaultSMTPMailServerDefined() && this.applicationProperties.getOption("jira.show.contact.administrators.form") && System.getProperty("atlassian.mail.senddisabled", "false").equals("false") && !this.applicationProperties.getOption("jira.mail.send.disabled");
    }

    public String getAdministratorContactLink(String baseUrl) {
        String url = baseUrl.endsWith("/") ? baseUrl + ADMINISTRATORS_LINK : baseUrl + "/" + ADMINISTRATORS_LINK;
        return url;
    }
}

