/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.component.AbstractComponentAdaptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.util.concurrent.LazyReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class I18nHelperComponentAdapter
extends AbstractComponentAdaptor<I18nHelper> {
    private final LazyReference<I18nHelper> proxyRef = new CglibProxyCreator();

    public I18nHelperComponentAdapter() {
        super(I18nHelper.class);
    }

    @Override
    public Class<?> getComponentImplementation() {
        return I18nHelper.class;
    }

    @Override
    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException {
        return this.proxyRef.get();
    }

    @Override
    public void verify() throws UnsatisfiableDependenciesException {
        this.getFactoryFromContainer();
    }

    protected I18nHelper.BeanFactory getFactoryFromContainer() {
        return this.getInstanceFromContainer(I18nHelper.BeanFactory.class);
    }

    protected <T> T getInstanceFromContainer(Class<T> cls) {
        Object factory = this.getContainer().getComponentInstanceOfType(cls);
        if (factory == null) {
            throw new UnsatisfiableDependenciesException((ComponentAdapter)this, Collections.singleton(cls));
        }
        return (T)factory;
    }

    static class DelegateToDateTimeFormatterInterceptor
    implements MethodInterceptor {
        private static Class[] EQUALS_PARAM_TYPES = new Class[]{Object.class};
        private static Class[] NO_PARAMS = new Class[0];
        private final JiraAuthenticationContext authenticationContext;
        private final I18nHelper.BeanFactory factory;

        public DelegateToDateTimeFormatterInterceptor(I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext authenticationContext) {
            this.authenticationContext = authenticationContext;
            this.factory = i18nFactory;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if ("equals".equals(method.getName()) && Arrays.equals(EQUALS_PARAM_TYPES, method.getParameterTypes())) {
                return this.equals(args[0]);
            }
            if ("hashCode".equals(method.getName()) && Arrays.equals(NO_PARAMS, method.getParameterTypes())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName()) && Arrays.equals(NO_PARAMS, method.getParameterTypes())) {
                return this.toString();
            }
            I18nHelper delegate = this.factory.getInstance(this.authenticationContext.getLoggedInUser());
            return proxy.invoke((Object)delegate, args);
        }
    }

    class CglibProxyCreator
    extends LazyReference<I18nHelper> {
        CglibProxyCreator() {
        }

        protected I18nHelper create() throws Exception {
            I18nHelper.BeanFactory factory = I18nHelperComponentAdapter.this.getFactoryFromContainer();
            JiraAuthenticationContext authContext = I18nHelperComponentAdapter.this.getInstanceFromContainer(JiraAuthenticationContext.class);
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(I18nHelper.class);
            enhancer.setCallback((Callback)new DelegateToDateTimeFormatterInterceptor(factory, authContext));
            return (I18nHelper)enhancer.create();
        }
    }
}

