/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.JiraKeyUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class UpgradeTask_Build6125
extends AbstractUpgradeTask {
    public static final String ISSUE_ENTITY_NAME = "Issue";
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6125.class);

    public UpgradeTask_Build6125() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "6125";
    }

    @Override
    public String getShortDescription() {
        return "Extract Issue number to a separate column";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        DateTime startedAt = new DateTime();
        Connection connection = this.getDatabaseConnection();
        try {
            connection.setAutoCommit(false);
            long issuesInTotal = this.getIssueCount();
            log.info((Object)String.format("There are %d Issues to be processed", issuesInTotal));
            String selectSql = "SELECT pkey FROM " + this.convertToSchemaTableName("jiraissue") + " WHERE pkey IS NOT NULL ";
            String updateSql = "UPDATE " + this.convertToSchemaTableName("jiraissue") + " SET issuenum = ? WHERE pkey = ? ";
            PreparedStatement selectStmt = connection.prepareStatement(selectSql);
            try {
                PreparedStatement updateStmt = connection.prepareStatement(updateSql);
                try {
                    ResultSet rs = selectStmt.executeQuery();
                    try {
                        DateTime lastReport = new DateTime();
                        long processed = 0L;
                        while (rs.next()) {
                            DateTime now;
                            String pkey = rs.getString("pkey");
                            updateStmt.setLong(1, this.getIssueNumberFromKey(pkey));
                            updateStmt.setString(2, pkey);
                            updateStmt.addBatch();
                            if (processed % 250L == 0L) {
                                updateStmt.executeBatch();
                                connection.commit();
                            }
                            if (Seconds.secondsBetween((ReadableInstant)lastReport, (ReadableInstant)(now = new DateTime())).isGreaterThan(Seconds.seconds((int)30))) {
                                lastReport = now;
                                log.info((Object)String.format("Processed %d Issues, %d left for processing", processed, issuesInTotal - processed));
                            }
                            ++processed;
                        }
                    }
                    finally {
                        rs.close();
                    }
                    updateStmt.executeBatch();
                }
                finally {
                    updateStmt.close();
                }
            }
            finally {
                selectStmt.close();
            }
            connection.commit();
        }
        catch (Exception e) {
            try {
                connection.rollback();
                throw e;
            }
            catch (Throwable throwable) {
                connection.close();
                log.info((Object)String.format("Upgrade task took %d seconds to complete", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds()));
                throw throwable;
            }
        }
        connection.close();
        log.info((Object)String.format("Upgrade task took %d seconds to complete", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds()));
    }

    protected long getIssueCount() {
        return Select.countFrom(ISSUE_ENTITY_NAME).runWith(UpgradeTask_Build6125.getOfBizDelegator()).singleValue();
    }

    protected long getIssueNumberFromKey(String pkey) {
        return JiraKeyUtils.getFastCountFromKey((String)pkey);
    }
}

