/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.web.action.setup.SetupOldUserHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build60
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build60.class);

    public UpgradeTask_Build60() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "60";
    }

    @Override
    public String getShortDescription() {
        return "Adding colors to Priorities so the status bar appearence can be configured. Adding View Control Permission to 'jira-developers' group.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        log.debug((Object)"UpgradeTask_Build60.doUpgrade");
        if (SetupOldUserHelper.groupExists("jira-developers")) {
            GenericValue scheme = ManagerFactory.getPermissionSchemeManager().getDefaultScheme();
            ManagerFactory.getPermissionManager().addPermission(29, scheme, "jira-developers", "group");
            log.info((Object)("Added 'View Version Control' permission to the 'jira-developers' group for the '" + scheme.getString("name") + "'."));
        }
        OfBizDelegator ofBizDelegator = UpgradeTask_Build60.getOfBizDelegator();
        ArrayList<GenericValue> toStore = new ArrayList<GenericValue>();
        List priorities = ofBizDelegator.findAll("Priority");
        for (GenericValue priority : priorities) {
            priority.set("statusColor", (Object)this.getColour(priority.getString("id")));
            toStore.add(priority);
        }
        ofBizDelegator.storeAll(toStore);
    }

    private String getColour(String id) {
        if (id == null) {
            return "#cccccc";
        }
        if (id.equals("5")) {
            return "#003300";
        }
        if (id.equals("4")) {
            return "#006600";
        }
        if (id.equals("3")) {
            return "#009900";
        }
        if (id.equals("2")) {
            return "#ff0000";
        }
        return "#cc0000";
    }
}

