/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.AbstractReindexUpgradeTask;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build56
extends AbstractReindexUpgradeTask {
    private static final String UPGRADE_SYSTEM_PROP = "jira.upgrade.build56.override";
    public static final String ERROR_MESSAGE_STATUSES = "Could not upgrade due to non default statuses. Please contact " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.support.mail.to") + " for more information.";
    public static final String ERROR_MESSAGE_WORKFLOW = "Could not upgrade due workflow inconsistencies.";
    private static final String STATUS_UNASSIGNED = "1";
    private static final String STATUS_ASSIGNED = "2";
    private final OfBizDelegator delegator;

    public UpgradeTask_Build56(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "56";
    }

    @Override
    public String getShortDescription() {
        return "Rename unassigned to open, move assigned issues to open and remove assigned status";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        GenericValue unassigned = ManagerFactory.getConstantsManager().getStatus(STATUS_UNASSIGNED);
        GenericValue assigned = ManagerFactory.getConstantsManager().getStatus(STATUS_ASSIGNED);
        if (!("Unassigned".equals(unassigned.getString("name")) && assigned != null && "Assigned".equals(assigned.getString("name")) || "Open".equals(unassigned.getString("name")) || Boolean.getBoolean(UPGRADE_SYSTEM_PROP))) {
            throw new Exception("Could not upgrade due to non default statuses ('" + unassigned.getString("name") + "' instead of 'Unassigned'; '" + assigned.getString("name") + "' instead of 'Assigned'). If these are logically equivalent you may force the upgrade by restarting JIRA with -D" + UPGRADE_SYSTEM_PROP + "=true. Otherwise please contact " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.support.mail.to") + " for more information.");
        }
        unassigned.set("name", (Object)"Open");
        unassigned.set("description", (Object)"The issue is open and ready for the assignee to start work on it.");
        unassigned.set("iconurl", (Object)"/images/icons/status_open.gif");
        unassigned.store();
        List byAnd = this.delegator.findByAnd("Issue", EasyMap.build((Object)"status", (Object)STATUS_ASSIGNED));
        ArrayList<Object> storing = new ArrayList<Object>();
        for (GenericValue issue : byAnd) {
            issue.set("status", (Object)STATUS_UNASSIGNED);
            storing.add(issue);
            List workflowEntries = this.delegator.findByAnd("OSWorkflowEntry", EasyMap.build((Object)"id", (Object)issue.getLong("workflowId")));
            for (GenericValue workflowEntry : workflowEntries) {
                if (workflowEntry == null) continue;
                List currentSteps = this.delegator.findByAnd("OSCurrentStep", EasyMap.build((Object)"entryId", (Object)workflowEntry.getLong("id")));
                for (Object currentStep1 : currentSteps) {
                    GenericEntity currentStep = (GenericEntity)currentStep1;
                    if (currentStep == null) continue;
                    currentStep.set("stepId", (Object)new Integer(1));
                    storing.add(currentStep);
                }
            }
        }
        this.delegator.storeAll(storing);
        if (assigned != null) {
            assigned.remove();
        }
        ManagerFactory.getConstantsManager().refreshStatuses();
        super.doUpgrade(setupMode);
    }
}

