/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build48
extends AbstractUpgradeTask {
    public UpgradeTask_Build48() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "48";
    }

    @Override
    public String getShortDescription() {
        return "Creates timeoriginalestimate field in Issue table. Add default hoursPerDay and daysPerWeek properties";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws GenericEntityException {
        ComponentAccessor.getApplicationProperties().setOption("jira.option.timetracking", true);
        ComponentAccessor.getApplicationProperties().setOption("jira.timetracking.estimates.legacy.behaviour", false);
        ComponentAccessor.getApplicationProperties().setString("jira.timetracking.format", "pretty");
        ComponentAccessor.getApplicationProperties().setString("jira.timetracking.default.unit", DateUtils.Duration.MINUTE.toString().toUpperCase());
        ComponentAccessor.getApplicationProperties().setString("jira.timetracking.days.per.week", "5");
        ComponentAccessor.getApplicationProperties().setString("jira.timetracking.hours.per.day", "8");
        ComponentAccessor.getApplicationProperties().setString("jira.issue.desc.original.timetrack", "This value can not be changed after work has begun on the issue.");
        List l = UpgradeTask_Build48.getOfBizDelegator().findAll("Issue");
        for (GenericValue issue : l) {
            Long timeOriginalEstimate = null;
            if (issue.getLong("timeestimate") != null) {
                timeOriginalEstimate = issue.getLong("timespent") == null ? issue.getLong("timeestimate") : new Long(issue.getLong("timeestimate") + issue.getLong("timespent"));
            }
            issue.set("timeoriginalestimate", timeOriginalEstimate);
            issue.store();
        }
    }
}

