/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build418
extends AbstractUpgradeTask {
    private static final String SYSTEM_PORTLET_PACKAGE = "com.atlassian.jira.plugin.system.portlets";
    private final OfBizDelegator ofBizDelegator;
    private static final String[] LEGACY_KEYS = new String[]{"PROJECTS", "PROJECTTABLE", "PROJECT", "PROJECTSTATS", "SAVEDFILTERS", "ASSIGNEDTOME", "INPROGRESS", "SEARCHREQUEST", "INTRODUCTION", "USERISSUES", "ADMIN"};

    public UpgradeTask_Build418(OfBizDelegator ofBizDelegator) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<String> legacyKeys = Arrays.asList(LEGACY_KEYS);
        HashMap<Long, String> portletIdToKey = new HashMap<Long, String>();
        OfBizListIterator iter = this.ofBizDelegator.findListIteratorByCondition("PortletConfiguration", (EntityCondition)new EntityExpr("portletId", EntityOperator.IN, legacyKeys));
        try {
            GenericValue portletConfigurationGV = iter.next();
            while (portletConfigurationGV != null) {
                String portletKey = portletConfigurationGV.getString("portletId");
                Long portletId = portletConfigurationGV.getLong("id");
                portletIdToKey.put(portletId, portletKey);
                portletConfigurationGV = iter.next();
            }
        }
        finally {
            iter.close();
        }
        for (Map.Entry portletEntry : portletIdToKey.entrySet()) {
            String newPortletKey = "com.atlassian.jira.plugin.system.portlets:" + ((String)portletEntry.getValue()).toLowerCase();
            this.ofBizDelegator.bulkUpdateByPrimaryKey("PortletConfiguration", MapBuilder.singletonMap((Object)"portletId", (Object)newPortletKey), CollectionBuilder.newBuilder((Object[])new Long[]{(Long)portletEntry.getKey()}).asList());
        }
        this.getFlushablePortletConfigurationStore().flush();
    }

    FlushablePortletConfigurationStore getFlushablePortletConfigurationStore() {
        return (FlushablePortletConfigurationStore)ComponentAccessor.getComponent(PortletConfigurationStore.class);
    }

    @Override
    public String getShortDescription() {
        return "Converting legacy portlet keys (e.g. INTRODUCTION) to the new format (e.g. com.atlassian.jira.plugin.system.portlets:introduction).";
    }

    @Override
    public String getBuildNumber() {
        return "418";
    }
}

