/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build11
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build11.class);
    private final ConstantsManager constantsManager;

    public UpgradeTask_Build11(ConstantsManager constantsManager) {
        super(false);
        this.constantsManager = constantsManager;
    }

    @Override
    public String getBuildNumber() {
        return "11";
    }

    @Override
    public String getShortDescription() {
        return "Setting up defaults for custom priorities, resolutions and types.";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        log.debug((Object)"UpgradeTask_Build11 - setting up defaults for custom priorities, resolutions and types.");
        this.addPriorities();
        this.addResolutions();
        this.addIssueTypes();
        this.constantsManager.refresh();
    }

    private void addIssueTypes() {
        try {
            UpgradeTask_Build11.createNewEntity("IssueType", 1, "Bug", "A problem which impairs or prevents the functions of the product.", "/images/icons/bug.gif");
            UpgradeTask_Build11.createNewEntity("IssueType", 2, "New Feature", "A new feature of the product, which has yet to be developed.", "/images/icons/newfeature.gif");
            UpgradeTask_Build11.createNewEntity("IssueType", 3, "Task", "A task that needs to be done.", "/images/icons/task.gif");
            UpgradeTask_Build11.createNewEntity("IssueType", 4, "Improvement", "An improvement or enhancement to an existing feature or task.", "/images/icons/improvement.gif");
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error adding resolution: " + (Object)((Object)e)), (Throwable)e);
            this.addError(this.getI18nBean().getText("admin.errors.error.adding.resolution"));
        }
    }

    private void addResolutions() {
        try {
            UpgradeTask_Build11.createNewEntity("Resolution", 1, "Fixed", "A fix for this issue is checked into the tree and tested.", null);
            UpgradeTask_Build11.createNewEntity("Resolution", 2, "Won't Fix", "The problem described is an issue which will never be fixed.", null);
            UpgradeTask_Build11.createNewEntity("Resolution", 3, "Duplicate", "The problem is a duplicate of an existing issue.", null);
            UpgradeTask_Build11.createNewEntity("Resolution", 4, "Incomplete", "The problem is not completely described.", null);
            UpgradeTask_Build11.createNewEntity("Resolution", 5, "Cannot Reproduce", "All attempts at reproducing this issue failed, or not enough information was available to reproduce the issue. Reading the code produces no clues as to why this behavior would occur. If more information appears later, please reopen the issue.", null);
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error adding resolution: " + (Object)((Object)e)), (Throwable)e);
            this.addError(this.getI18nBean().getText("admin.errors.error.adding.resolution"));
        }
    }

    private void addPriorities() {
        try {
            UpgradeTask_Build11.createNewEntity("Priority", 1, "Blocker", "Blocks development and/or testing work, production could not run.", "/images/icons/priority_blocker.gif");
            UpgradeTask_Build11.createNewEntity("Priority", 2, "Critical", "Crashes, loss of data, severe memory leak.", "/images/icons/priority_critical.gif");
            UpgradeTask_Build11.createNewEntity("Priority", 3, "Major", "Major loss of function.", "/images/icons/priority_major.gif");
            UpgradeTask_Build11.createNewEntity("Priority", 4, "Minor", "Minor loss of function, or other problem where easy workaround is present.", "/images/icons/priority_minor.gif");
            UpgradeTask_Build11.createNewEntity("Priority", 5, "Trivial", "Cosmetic problem like misspelt words or misaligned text.", "/images/icons/priority_trivial.gif");
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error adding priority: " + (Object)((Object)e)), (Throwable)e);
            this.addError(this.getI18nBean().getText("admin.errors.error.adding.priority"));
        }
    }

    public static void createNewEntity(String entityName, int id, String name, String description, String iconurl) throws GenericEntityException {
        GenericValue gv = UpgradeTask_Build11.getOfBizDelegator().findByPrimaryKey(entityName, EasyMap.build((Object)"id", (Object)Long.toString(id)));
        if (gv == null) {
            Map fields = EasyMap.build((Object)"id", (Object)Long.toString(id), (Object)"sequence", (Object)new Long(id), (Object)"name", (Object)name, (Object)"iconurl", (Object)iconurl, (Object)"description", (Object)description);
            EntityUtils.createValue(entityName, fields);
        } else {
            log.warn((Object)("Could not doImport new " + entityName + " as one already exists with id: " + id));
        }
    }
}

