/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.cache.HashRegistryCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.FormattedLogMsg;
import com.atlassian.jira.startup.JiraSystemInfo;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.util.concurrent.ThreadFactories;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JiraStartupLogger {
    private static final Logger log = Logger.getLogger(JiraStartupLogger.class);
    private final BuildUtilsInfo buildUtilsInfo = new BuildUtilsInfoImpl();

    public static Logger log() {
        return log;
    }

    public void printMessage(String message, Level logLevel) {
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        logMsg.add(message);
        logMsg.printMessage(logLevel, true);
    }

    public void printMessage(Collection<String> messages, Level logLevel) {
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        logMsg.addAll(messages);
        logMsg.printMessage(logLevel, true);
    }

    public void printStartingMessage() {
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        logMsg.add("JIRA starting...");
        logMsg.printMessage(Level.INFO);
        try {
            JiraSystemInfo info = new JiraSystemInfo(logMsg, this.buildUtilsInfo);
            info.obtainBasicInfo(ServletContextProvider.getServletContext());
            if (!JiraSystemProperties.isDevMode()) {
                info.obtainSystemProperties();
            }
        }
        catch (RuntimeException rte) {
            log.error((Object)"Cannnot obtain basic JIRA information", (Throwable)rte);
        }
        catch (Error e) {
            log.error((Object)"Cannot obtain basic JIRA information", (Throwable)e);
        }
        logMsg.printMessage(Level.INFO, false);
    }

    public void printStartingMessageDatabaseOK() {
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        try {
            logMsg.add("Database configuration OK");
            JiraSystemInfo info = new JiraSystemInfo(logMsg, this.buildUtilsInfo);
            info.obtainDatabaseConfigurationInfo();
            logMsg.printMessage(Level.INFO, false);
        }
        catch (RuntimeException rte) {
            log.error((Object)"Cannot obtain JIRA database information", (Throwable)rte);
        }
    }

    public void printStartedMessage() {
        StringBuffer sb;
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        try {
            JiraSystemInfo info = new JiraSystemInfo(logMsg, this.buildUtilsInfo);
            info.obtainUserDirectoyInfo();
            info.obtainJiraAppProperties();
            info.obtainDatabaseStatistics();
            info.obtainUpgradeHistory();
            info.obtainFilePaths((JiraHome)ComponentAccessor.getComponent(JiraHome.class));
            info.obtainPlugins();
            info.obtainListeners();
            info.obtainServices();
            info.obtainTrustedApps();
            info.obtainSystemPathProperties();
            if (!JiraSystemProperties.isDevMode()) {
                logMsg.printMessage(Level.INFO, false);
            }
        }
        catch (RuntimeException rte) {
            log.error((Object)"Cannnot obtain JIRA system information", (Throwable)rte);
        }
        logMsg = new FormattedLogMsg(log);
        HashSet<UnloadablePlugin> disabledPlugins = new HashSet<UnloadablePlugin>();
        for (Plugin plugin : ComponentAccessor.getPluginAccessor().getPlugins()) {
            if (!(plugin instanceof UnloadablePlugin)) continue;
            disabledPlugins.add((UnloadablePlugin)plugin);
        }
        if (!disabledPlugins.isEmpty()) {
            sb = new StringBuffer().append("The following plugins failed to load:");
            for (UnloadablePlugin disabledPlugin : disabledPlugins) {
                sb.append("\n");
                sb.append(disabledPlugin.getName());
                String errorMessage = disabledPlugin.getErrorText();
                if (errorMessage == null || errorMessage.length() == 0) {
                    errorMessage = "(no error message)";
                }
                sb.append(": ").append(errorMessage);
            }
            logMsg.add(sb);
            logMsg.printMessage(Level.WARN, true);
        }
        logMsg = new FormattedLogMsg(log);
        sb = new StringBuffer().append("JIRA ").append(this.buildUtilsInfo.getVersion()).append(" build: ").append(this.buildUtilsInfo.getCurrentBuildNumber()).append(" started. You can now access JIRA through your web browser.");
        logMsg.add(sb);
        logMsg.printMessage(Level.INFO);
        LoginLoggers.LOGIN_SECURITY_EVENTS.warn((Object)sb);
        ExecutorService pool = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)"Modification Check", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
        pool.execute(new ModificationCheck(logMsg));
    }

    private static class ModificationCheck
    implements Runnable {
        private final FormattedLogMsg logMsg;

        public ModificationCheck(FormattedLogMsg logMsg) {
            this.logMsg = logMsg;
        }

        @Override
        public void run() {
            try {
                HashRegistryCache registry = (HashRegistryCache)ComponentAccessor.getComponentOfType(HashRegistryCache.class);
                Modifications modifications = registry.getModifications();
                String modifiedFilesDescription = "None";
                String removedFilesDescription = "None";
                if (!modifications.modifiedFiles.isEmpty()) {
                    modifiedFilesDescription = StringUtils.join((Collection)modifications.modifiedFiles, (String)", ");
                }
                if (!modifications.removedFiles.isEmpty()) {
                    removedFilesDescription = StringUtils.join((Collection)modifications.removedFiles, (String)", ");
                }
                this.logMsg.outputHeader("Modifications");
                this.logMsg.outputProperty("Modified Files", modifiedFilesDescription);
                this.logMsg.outputProperty("Removed Files", removedFilesDescription);
                this.logMsg.printMessage(Level.INFO, false);
            }
            catch (ModzRegistryException e) {
                this.logMsg.add("Could not determine modifications: " + e.toString());
                this.logMsg.printMessage(Level.WARN, false);
            }
        }
    }
}

