/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.JiraFailedPluginTracker;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.plugin.PluginArtifact;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;

public class FailedPluginsLauncher
implements JiraLauncher {
    @Override
    public void start() {
        JiraFailedPluginTracker failedPluginTracker = (JiraFailedPluginTracker)ComponentAccessor.getComponent(JiraFailedPluginTracker.class);
        ArrayList failedPlugins = Lists.newArrayList(failedPluginTracker.getFailedPlugins());
        if (!failedPlugins.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("___ FAILED PLUGIN REPORT _____________________\n", new Object[0]));
            int size = failedPlugins.size();
            sb.append(String.format("\n%d %s failed to load during JIRA startup.", size, size == 1 ? "plugin" : "plugins"));
            for (JiraFailedPluginTracker.PluginInfo failedPlugin : failedPlugins) {
                this.printFailedPlugin(sb, failedPlugin, "failed to load.");
            }
            ArrayList unaccountedForPlugins = Lists.newArrayList(failedPluginTracker.getUnaccountedForPlugins());
            size = unaccountedForPlugins.size();
            if (!unaccountedForPlugins.isEmpty()) {
                sb.append(String.format("\n%d %s are unaccounted for.", size, size == 1 ? "plugin" : "plugins"));
                sb.append(String.format("\nUnaccounted for plugins load as artifacts but fail to resolve into full plugins.", new Object[0]));
                for (JiraFailedPluginTracker.PluginInfo pluginInfo : unaccountedForPlugins) {
                    this.printFailedPlugin(sb, pluginInfo, "is unaccounted for.");
                }
            }
            sb.append("\n");
            JiraStartupLogger logger = new JiraStartupLogger();
            logger.printMessage(sb.toString(), Level.WARN);
        }
    }

    private void printFailedPlugin(StringBuilder sb, JiraFailedPluginTracker.PluginInfo failedPlugin, String reason) {
        Option<PluginArtifact> pluginArtifact = failedPlugin.getPluginArtifact();
        List failureCauses = (List)failedPlugin.getFailureCauses().getOrElse(Collections.emptyList());
        List<JiraFailedPluginTracker.ServiceDependency> missingDeps = failedPlugin.getDependencies();
        sb.append(String.format("\n\n\t'%s' - '%s'  " + reason, failedPlugin.getPluginKey(), failedPlugin.getPluginName()));
        for (String failureCause : failureCauses) {
            sb.append(String.format("\n\t\t%s", failureCause));
        }
        if (!missingDeps.isEmpty()) {
            sb.append(String.format("\n\n\t\tIt has the following missing service dependencies :", new Object[0]));
            for (JiraFailedPluginTracker.ServiceDependency dep : missingDeps) {
                sb.append(String.format("\n\t\t\t %s of type %s", dep.getServiceName(), dep.getServiceClass()));
            }
        }
        if (pluginArtifact.isDefined()) {
            sb.append(String.format("\n\n\t\tIt was loaded from %s", ((PluginArtifact)pluginArtifact.get()).toFile().getPath()));
        }
    }

    @Override
    public void stop() {
    }
}

