/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.JiraHomePathLocator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CompositeJiraHomePathLocator
implements JiraHomePathLocator {
    private static final Logger log = Logger.getLogger(CompositeJiraHomePathLocator.class);
    private final List<JiraHomePathLocator> locators;

    public CompositeJiraHomePathLocator(JiraHomePathLocator ... locators) {
        this.locators = CollectionBuilder.newBuilder((Object[])locators).asList();
    }

    @Override
    public String getJiraHome() {
        for (JiraHomePathLocator homePathLocator : this.locators) {
            String jiraHome;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for jira.home using " + homePathLocator));
            }
            if (!StringUtils.isNotBlank((String)(jiraHome = homePathLocator.getJiraHome()))) continue;
            log.debug((Object)("jira.home '" + jiraHome + "' found using " + homePathLocator.getDisplayName() + '.'));
            return jiraHome.trim();
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Composite";
    }
}

