/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soap.axis;

import com.atlassian.jira.plugin.rpc.SoapModuleDescriptor;
import com.atlassian.jira.soap.axis.JiraSoapTokenResolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.java.RPCProvider;

public class JiraAxisJavaPicoRPCProvider
extends RPCProvider {
    private final List<JiraSoapTokenResolver> tokenResolvers = new ArrayList<JiraSoapTokenResolver>();
    private final SoapModuleDescriptor descriptor;

    public JiraAxisJavaPicoRPCProvider(SoapModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected Class getServiceClass(String clsName, SOAPService service, MessageContext msgContext) {
        return this.descriptor.getPublishedInterface();
    }

    protected Object makeNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        Object soapServiceInstance = this.descriptor.getModule();
        if (soapServiceInstance instanceof JiraSoapTokenResolver) {
            this.tokenResolvers.add((JiraSoapTokenResolver)soapServiceInstance);
        }
        return soapServiceInstance;
    }

    protected RPCElement getBody(SOAPEnvelope reqEnv, MessageContext msgContext) throws Exception {
        return super.getBody(reqEnv, msgContext);
    }

    protected String resolveTokenToUserName(String token) {
        JiraSoapTokenResolver jiraAxisTokenResolver;
        String userName = null;
        Iterator<JiraSoapTokenResolver> i$ = this.tokenResolvers.iterator();
        while (i$.hasNext() && (userName = (jiraAxisTokenResolver = i$.next()).resolveTokenToUserName(token)) == null) {
        }
        return userName;
    }

    protected int getTokenParameterIndex(String operationName) {
        JiraSoapTokenResolver jiraAxisTokenResolver;
        int parameterIndex = -1;
        Iterator<JiraSoapTokenResolver> i$ = this.tokenResolvers.iterator();
        while (i$.hasNext() && (parameterIndex = (jiraAxisTokenResolver = i$.next()).getTokenParameterIndex(operationName)) == -1) {
        }
        return parameterIndex;
    }
}

