/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.AbstractShareType;
import com.atlassian.jira.sharing.type.GlobalShareType;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultShareTypeFactory
implements ShareTypeFactory {
    private final Map<ShareType.Name, ShareType> shareMap;
    private final List<ShareType> shareList;

    public DefaultShareTypeFactory(GlobalShareType globalShareType, GroupShareType groupShareType, ProjectShareType projectShareType) {
        this(new HashSet<ShareType>(Lists.newArrayList((Object[])new AbstractShareType[]{globalShareType, groupShareType, projectShareType})));
    }

    DefaultShareTypeFactory(Set<ShareType> types) {
        Assertions.notNull((String)"types", types);
        ArrayList<ShareType> typesList = new ArrayList<ShareType>(types);
        Collections.sort(typesList, new ShareTypeComparator());
        HashMap<ShareType.Name, ShareType> typesMap = new HashMap<ShareType.Name, ShareType>();
        Iterator i$ = typesList.iterator();
        while (i$.hasNext()) {
            ShareType element;
            ShareType shareType = element = (ShareType)i$.next();
            typesMap.put(shareType.getType(), shareType);
        }
        this.shareMap = Collections.unmodifiableMap(typesMap);
        this.shareList = Collections.unmodifiableList(typesList);
    }

    public Collection<ShareType> getAllShareTypes() {
        return this.shareList;
    }

    public ShareType getShareType(ShareType.Name type) {
        Assertions.notNull((String)"type", (Object)type);
        return this.shareMap.get(type);
    }

    public Comparator<SharePermission> getPermissionComparator() {
        return new SharePermissionsComparator();
    }

    private static class ShareTypeComparator
    implements Comparator<ShareType> {
        private ShareTypeComparator() {
        }

        @Override
        public int compare(ShareType type1, ShareType type2) {
            return type1.getPriority() - type2.getPriority();
        }
    }

    private class SharePermissionsComparator
    implements Comparator<SharePermission> {
        private SharePermissionsComparator() {
        }

        @Override
        public int compare(SharePermission o1, SharePermission o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ShareType type1 = DefaultShareTypeFactory.this.getShareType(o1.getType());
            if (o1.getType().equals((Object)o2.getType())) {
                return type1.getComparator().compare(o1, o2);
            }
            ShareType type2 = DefaultShareTypeFactory.this.getShareType(o2.getType());
            if (type1 == null) {
                if (type2 == null) {
                    return 0;
                }
                return -1;
            }
            if (type2 == null) {
                return 1;
            }
            return type1.getPriority() - type2.getPriority();
        }
    }
}

