/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.google.common.annotations.VisibleForTesting;
import com.octo.captcha.CaptchaException;
import com.octo.captcha.service.CaptchaServiceException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JiraCaptchaServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(JiraCaptchaServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
            try {
                String captchaId = request.getSession().getId();
                BufferedImage imageChallenge = null;
                while (imageChallenge == null) {
                    try {
                        imageChallenge = this.getCaptchaService().getImageCaptchaService().getImageChallengeForID(captchaId, request.getLocale());
                    }
                    catch (CaptchaException e) {
                        log.debug((Object)"CaptchaException thrown when image was being generated. This was most likely caused by running on OS X which has font size issues. Ignoring the exception. See http://jcaptcha.octo.com/jira/browse/FWK-58.", (Throwable)e);
                    }
                }
                this.writeJpegImage(jpegOutputStream, imageChallenge);
            }
            catch (IllegalArgumentException e) {
                response.sendError(404);
                return;
            }
            catch (CaptchaServiceException e) {
                response.sendError(500);
                return;
            }
            byte[] captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
            this.setResponseHeaders(response);
            ServletOutputStream responseOutputStream = response.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setResponseHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
    }

    @VisibleForTesting
    JiraCaptchaService getCaptchaService() {
        return (JiraCaptchaService)ComponentAccessor.getComponent(JiraCaptchaService.class);
    }

    private void writeJpegImage(ByteArrayOutputStream os, BufferedImage bufferedImage) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(os);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        writer.setOutput(imageOutputStream);
        writer.write(bufferedImage);
    }
}

