/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class XsrfTokenAdditionRequestFilter
implements Filter {
    private static final String ALREADY_FILTERED = XsrfTokenAdditionRequestFilter.class.getName() + "_already_filtered";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String jiraSetup = this.getJiraApplicationProperties().getString("jira.setup");
        if (servletRequest.getAttribute(ALREADY_FILTERED) != null || jiraSetup == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        servletRequest.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        this.setXsrfToken(httpServletRequest);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    protected ApplicationProperties getJiraApplicationProperties() {
        return (ApplicationProperties)ComponentAccessor.getComponentOfType(ApplicationProperties.class);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private void setXsrfToken(HttpServletRequest httpServletRequest) {
        this.getXsrfTokenGenerator().generateToken(httpServletRequest);
    }

    XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
    }
}

