/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class DefaultRoleActorsImpl
implements DefaultRoleActors {
    private final Set roleActors;
    private final Long projectRoleId;

    public DefaultRoleActorsImpl(Long projectRoleId, Set roleActors) {
        this.projectRoleId = projectRoleId;
        this.roleActors = Collections.unmodifiableSet(new HashSet(roleActors));
    }

    public DefaultRoleActorsImpl(Long projectRoleId, RoleActor roleActor) {
        this(projectRoleId, new HashSet(EasyList.build((Object)roleActor)));
    }

    public Set<User> getUsers() {
        HashSet<User> allUsers = new HashSet<User>();
        if (this.roleActors != null) {
            for (Object roleActor : this.roleActors) {
                RoleActor actor = (RoleActor)roleActor;
                for (User user : actor.getUsers()) {
                    allUsers.add(user);
                }
            }
        }
        return allUsers;
    }

    public Set<ApplicationUser> getApplicationUsers() {
        HashSet<ApplicationUser> allUsers = new HashSet<ApplicationUser>();
        if (this.roleActors != null) {
            for (Object roleActor : this.roleActors) {
                RoleActor actor = (RoleActor)roleActor;
                for (User user : actor.getUsers()) {
                    allUsers.add(ApplicationUsers.from((User)user));
                }
            }
        }
        return allUsers;
    }

    public Set getRoleActors() {
        return this.roleActors;
    }

    public Long getProjectRoleId() {
        return this.projectRoleId;
    }

    public Set getRoleActorsByType(String type) {
        TreeSet<RoleActor> roleActorsForType = new TreeSet<RoleActor>(RoleActorComparator.COMPARATOR);
        for (Object roleActor1 : this.roleActors) {
            RoleActor roleActor = (RoleActor)roleActor1;
            if (!roleActor.getType().equals(type)) continue;
            roleActorsForType.add(roleActor);
        }
        return roleActorsForType;
    }

    public boolean contains(ApplicationUser user) {
        for (Object roleActor1 : this.roleActors) {
            RoleActor roleActor = (RoleActor)roleActor1;
            if (!roleActor.contains(user)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(User user) {
        return this.contains(ApplicationUsers.from((User)user));
    }

    public DefaultRoleActors addRoleActor(RoleActor roleActor) {
        HashSet<RoleActor> set = new HashSet<RoleActor>(this.roleActors);
        set.add(roleActor);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public DefaultRoleActors addRoleActors(Collection roleActors) {
        HashSet set = new HashSet(this.roleActors);
        set.addAll(roleActors);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
        if (!this.roleActors.contains(roleActor)) {
            return this;
        }
        HashSet set = new HashSet(this.roleActors);
        set.remove(roleActor);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }

    public DefaultRoleActors removeRoleActors(Collection roleActors) {
        HashSet set = new HashSet(this.roleActors);
        set.removeAll(roleActors);
        return new DefaultRoleActorsImpl(this.projectRoleId, set);
    }
}

