/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@EventComponent
public class CachingProjectRoleAndActorStore
implements ProjectRoleAndActorStore {
    private final ProjectRoleAndActorStore delegate;
    private final RoleActorFactory roleActorFactory;
    private final ProjectRoleActorsCache roleActorsCache = new ProjectRoleActorsCache();
    private final ProjectRoleCache roleCache = new ProjectRoleCache();

    public CachingProjectRoleAndActorStore(ProjectRoleAndActorStore delegate, RoleActorFactory roleActorFactory) {
        this.delegate = delegate;
        this.roleActorFactory = roleActorFactory;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches();
    }

    @Override
    public ProjectRole addProjectRole(ProjectRole projectRole) throws DataAccessException {
        ProjectRole role = this.delegate.addProjectRole(projectRole);
        return this.roleCache.add(role);
    }

    @Override
    public void updateProjectRole(ProjectRole projectRole) throws DataAccessException {
        this.delegate.updateProjectRole(projectRole);
        this.roleCache.update(projectRole);
    }

    @Override
    public Collection<ProjectRole> getAllProjectRoles() throws DataAccessException {
        return this.roleCache.getAll();
    }

    @Override
    public ProjectRole getProjectRole(Long id) throws DataAccessException {
        return this.roleCache.get(id);
    }

    @Override
    public ProjectRole getProjectRoleByName(String name) throws DataAccessException {
        return this.roleCache.get(name);
    }

    @Override
    public void deleteProjectRole(ProjectRole projectRole) throws DataAccessException {
        this.roleCache.remove(projectRole);
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(Long projectRoleId) throws DataAccessException {
        return this.roleActorsCache.get(projectRoleId, null);
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(Long projectRoleId, Long projectId) throws DataAccessException {
        return (ProjectRoleActors)this.roleActorsCache.get(projectRoleId, projectId);
    }

    @Override
    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) throws DataAccessException {
        this.delegate.updateProjectRoleActors(projectRoleActors);
        this.roleActorsCache.put(projectRoleActors.getProjectId(), (DefaultRoleActors)projectRoleActors);
    }

    @Override
    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) throws DataAccessException {
        this.delegate.updateDefaultRoleActors(defaultRoleActors);
        this.roleActorsCache.put(null, defaultRoleActors);
    }

    @Override
    public void applyDefaultsRolesToProject(Project project) throws DataAccessException {
        this.delegate.applyDefaultsRolesToProject(project);
    }

    @Override
    public void removeAllRoleActorsByKeyAndType(String key, String type) throws DataAccessException {
        this.delegate.removeAllRoleActorsByKeyAndType(key, type);
        this.roleActorsCache.clear();
    }

    @Override
    public void removeAllRoleActorsByProject(Project project) throws DataAccessException {
        this.delegate.removeAllRoleActorsByProject(project);
        this.roleActorsCache.removeByProject(project);
    }

    @Override
    public Collection<Long> getProjectIdsContainingRoleActorByKeyAndType(String key, String type) throws DataAccessException {
        return this.delegate.getProjectIdsContainingRoleActorByKeyAndType(key, type);
    }

    @Override
    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) throws DataAccessException {
        return this.delegate.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter);
    }

    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userKey) throws DataAccessException {
        return this.delegate.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userKey);
    }

    public void clearCaches() {
        this.roleActorsCache.clear();
        this.roleCache.clear();
    }

    private class CachedDefaultRoleActors
    implements ProjectRoleActors {
        private final DefaultRoleActors delegate;
        private final Set<RoleActor> optimizedProjectRoleSet;

        CachedDefaultRoleActors(DefaultRoleActors delegate) {
            this.delegate = delegate;
            this.optimizedProjectRoleSet = Collections.unmodifiableSet(CachingProjectRoleAndActorStore.this.roleActorFactory.optimizeRoleActorSet(delegate.getRoleActors()));
        }

        public boolean contains(ApplicationUser user) {
            for (RoleActor o : this.optimizedProjectRoleSet) {
                if (!o.contains(user)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(User user) {
            for (RoleActor o : this.optimizedProjectRoleSet) {
                if (!o.contains(user)) continue;
                return true;
            }
            return false;
        }

        public Long getProjectId() {
            return this.delegate instanceof ProjectRoleActors ? ((ProjectRoleActors)this.delegate).getProjectId() : null;
        }

        public Set<User> getUsers() {
            return this.delegate.getUsers();
        }

        public Set<ApplicationUser> getApplicationUsers() {
            return this.delegate.getApplicationUsers();
        }

        public Set<RoleActor> getRoleActors() {
            return this.delegate.getRoleActors();
        }

        public Long getProjectRoleId() {
            return this.delegate.getProjectRoleId();
        }

        public Set<RoleActor> getRoleActorsByType(String type) {
            return this.delegate.getRoleActorsByType(type);
        }

        public DefaultRoleActors addRoleActors(Collection<RoleActor> roleActors) {
            return this.delegate.addRoleActors(roleActors);
        }

        public DefaultRoleActors addRoleActor(RoleActor roleActor) {
            return this.delegate.addRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
            return this.delegate.removeRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActors(Collection<RoleActor> roleActors) {
            return this.delegate.removeRoleActors(roleActors);
        }
    }

    private abstract class ProjectRoleMap {
        private final ConcurrentMap<String, ProjectRole> map = new ConcurrentHashMap<String, ProjectRole>();

        private ProjectRoleMap() {
        }

        ProjectRole get(String key) {
            ProjectRole projectRole = (ProjectRole)this.map.get(key);
            if (projectRole == null && (projectRole = this.getFromDelegate(key)) != null) {
                ProjectRole result = this.map.putIfAbsent(this.getKey(projectRole), projectRole);
                return result == null ? projectRole : result;
            }
            return projectRole;
        }

        void add(ProjectRole role) {
            Assertions.notNull((String)"ProjectRole cannot be null", (Object)role);
            this.map.put(this.getKey(role), role);
        }

        ProjectRole remove(ProjectRole role) {
            Assertions.notNull((String)"ProjectRole cannot be null", (Object)role);
            return (ProjectRole)this.map.remove(this.getKey(role));
        }

        void clear() {
            this.map.clear();
        }

        abstract String getKey(ProjectRole var1);

        abstract ProjectRole getFromDelegate(String var1);
    }

    private class ProjectRoleCache {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final List<ProjectRole> projectRoles = new CopyOnWriteArrayList<ProjectRole>();
        private final ProjectRoleMap projectRolesByName = new ProjectRoleMap(){

            @Override
            String getKey(ProjectRole role) {
                return role.getName();
            }

            @Override
            ProjectRole getFromDelegate(String key) {
                return CachingProjectRoleAndActorStore.this.delegate.getProjectRoleByName(key);
            }
        };
        private final ProjectRoleMap projectRolesById = new ProjectRoleMap(){

            @Override
            String getKey(ProjectRole role) {
                return role.getId().toString();
            }

            @Override
            ProjectRole getFromDelegate(String key) {
                return CachingProjectRoleAndActorStore.this.delegate.getProjectRole(new Long(key));
            }
        };

        private ProjectRoleCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.lock.writeLock().lock();
            try {
                this.projectRoles.clear();
                this.projectRolesById.clear();
                this.projectRolesByName.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProjectRole add(ProjectRole role) {
            this.lock.writeLock().lock();
            try {
                this.projectRolesById.add(role);
                this.projectRolesByName.add(role);
                this.projectRoles.clear();
                ProjectRole projectRole = role;
                return projectRole;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(ProjectRole projectRole) throws DataAccessException {
            this.lock.writeLock().lock();
            try {
                ProjectRole oldRole = this.projectRolesById.remove(projectRole);
                this.projectRolesByName.remove(projectRole);
                if (oldRole != null) {
                    this.projectRolesByName.remove(oldRole);
                }
                this.projectRoles.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProjectRole get(String name) {
            this.lock.readLock().lock();
            try {
                ProjectRole projectRole = this.projectRolesByName.get(name);
                return projectRole;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProjectRole get(Long id) {
            this.lock.readLock().lock();
            try {
                ProjectRole projectRole = this.projectRolesById.get(id.toString());
                return projectRole;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<ProjectRole> getAll() throws DataAccessException {
            if (this.projectRoles.size() == 0) {
                Collection<ProjectRole> allProjectRoles = CachingProjectRoleAndActorStore.this.delegate.getAllProjectRoles();
                this.lock.writeLock().lock();
                try {
                    if (this.projectRoles.size() == 0) {
                        this.projectRoles.addAll(allProjectRoles);
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            return Collections.unmodifiableCollection(this.projectRoles);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ProjectRole projectRole) {
            CachingProjectRoleAndActorStore.this.delegate.deleteProjectRole(projectRole);
            if (projectRole == null) {
                return;
            }
            this.lock.writeLock().lock();
            try {
                ProjectRole oldRole = null;
                if (projectRole.getId() != null) {
                    oldRole = this.projectRolesById.remove(projectRole);
                }
                if (projectRole.getName() != null) {
                    this.projectRolesByName.remove(projectRole);
                }
                if (oldRole != null) {
                    this.projectRolesByName.remove(projectRole);
                }
                this.projectRoles.remove(projectRole);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static class ProjectRoleActorKey {
        final Long projectRoleId;
        final Long projectId;

        private ProjectRoleActorKey(Long projectRoleId, Long projectId) {
            this.projectRoleId = projectRoleId;
            this.projectId = projectId;
        }

        public Long getProjectRoleId() {
            return this.projectRoleId;
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectRoleActorKey that = (ProjectRoleActorKey)o;
            if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) {
                return false;
            }
            return !(this.projectRoleId != null ? !this.projectRoleId.equals(that.projectRoleId) : that.projectRoleId != null);
        }

        public int hashCode() {
            int result = this.projectRoleId != null ? this.projectRoleId.hashCode() : 0;
            result = 31 * result + (this.projectId != null ? this.projectId.hashCode() : 0);
            return result;
        }
    }

    private class ProjectRoleActorsCache {
        private final ConcurrentMap<ProjectRoleActorKey, DefaultRoleActors> roleActorsByProjectAndRole = new MapMaker().makeComputingMap((Function)new Function<ProjectRoleActorKey, DefaultRoleActors>(){

            public DefaultRoleActors apply(ProjectRoleActorKey from) {
                Object roleActors = from.getProjectId() == null ? CachingProjectRoleAndActorStore.this.delegate.getDefaultRoleActors(from.getProjectRoleId()) : CachingProjectRoleAndActorStore.this.delegate.getProjectRoleActors(from.getProjectRoleId(), from.getProjectId());
                if (roleActors != null) {
                    return new CachedDefaultRoleActors((DefaultRoleActors)roleActors);
                }
                return null;
            }
        });

        private ProjectRoleActorsCache() {
        }

        void put(Long projectId, DefaultRoleActors roleActors) {
            this.roleActorsByProjectAndRole.put(new ProjectRoleActorKey(roleActors.getProjectRoleId(), projectId), (DefaultRoleActors)new CachedDefaultRoleActors(roleActors));
        }

        DefaultRoleActors get(Long projectRoleId, Long projectId) {
            return (DefaultRoleActors)this.roleActorsByProjectAndRole.get(new ProjectRoleActorKey(projectRoleId, projectId));
        }

        void remove(Long projectRoleId, Long projectId) {
            this.roleActorsByProjectAndRole.remove(new ProjectRoleActorKey(projectRoleId, projectId));
        }

        void removeByProject(Project project) {
            Iterator iterator = this.roleActorsByProjectAndRole.keySet().iterator();
            while (iterator.hasNext()) {
                ProjectRoleActorKey key = (ProjectRoleActorKey)iterator.next();
                if (key.getProjectId() == null || !key.getProjectId().equals(project.getId())) continue;
                iterator.remove();
            }
        }

        void clear() {
            this.roleActorsByProjectAndRole.clear();
        }
    }
}

