/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.distiller;

import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeComparator;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.SchemeEntityType;
import com.atlassian.jira.scheme.distiller.SchemeRelationship;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;

public class SchemeRelationships {
    private Map relationshipByEntityType;
    private Collection distilledSchemes = null;
    private List schemes = null;
    private Collection distilledResults;

    public SchemeRelationships(Collection distilledResults, Collection schemes, Collection entityTypes) {
        this.distilledResults = distilledResults;
        this.distilledSchemes = new ArrayList();
        for (Object distilledResult : distilledResults) {
            DistilledSchemeResult distilledSchemeResult = (DistilledSchemeResult)distilledResult;
            this.distilledSchemes.add(distilledSchemeResult.getResultingScheme());
        }
        this.schemes = new ArrayList(this.distilledSchemes);
        this.schemes.addAll(schemes);
        Collections.sort(this.schemes, new SchemeComparator());
        this.relationshipByEntityType = new ListOrderedMap();
        this.createSchemeRelationshipsForEntityTypes(entityTypes, this.schemes);
    }

    public DistilledSchemeResult getDistilledSchemeResultForScheme(Scheme resultingScheme) {
        for (Object distilledResult : this.distilledResults) {
            DistilledSchemeResult distilledSchemeResult = (DistilledSchemeResult)distilledResult;
            if (!distilledSchemeResult.getResultingScheme().equals(resultingScheme)) continue;
            return distilledSchemeResult;
        }
        return null;
    }

    public Collection getEntityTypes() {
        return this.relationshipByEntityType.keySet();
    }

    public Collection getSchemes() {
        return this.schemes;
    }

    public Collection getDistilledSchemes() {
        return this.distilledSchemes;
    }

    public boolean isSchemeDistilled(Scheme scheme) {
        return this.distilledSchemes.contains(scheme);
    }

    public boolean allMatchForEntityType(Object entityType) {
        return this.getSchemeRelationshipForEntityType(entityType).allMatch();
    }

    public List getSchemeRelationships() {
        return new ArrayList(this.relationshipByEntityType.values());
    }

    public SchemeRelationship getSchemeRelationshipForEntityType(Object entityType) {
        SchemeRelationship schemeRelationship = (SchemeRelationship)this.relationshipByEntityType.get(entityType);
        if (schemeRelationship != null) {
            return schemeRelationship;
        }
        throw new IllegalArgumentException("There are no scheme relationships registered for entityType: " + entityType);
    }

    public double getSchemeDifferencePercentage() {
        double matchingSchemeEntitiesCount = this.getAllMatchingSchemeEntities().size();
        double totalSchemeEntitiesCount = this.getAllSchemeEntities().size();
        if (totalSchemeEntitiesCount == 0.0) {
            return 0.0;
        }
        return 1.0 - matchingSchemeEntitiesCount / totalSchemeEntitiesCount;
    }

    private void createSchemeRelationshipsForEntityTypes(Collection entityTypes, Collection schemes) {
        for (Object entityType : entityTypes) {
            SchemeEntityType schemeEntityType = (SchemeEntityType)entityType;
            this.relationshipByEntityType.put(schemeEntityType.getEntityTypeId(), new SchemeRelationship(schemeEntityType.getEntityTypeId(), schemeEntityType.getDisplayName(), schemes));
        }
    }

    private Set getAllSchemeEntities() {
        HashSet ret = new HashSet();
        for (Object key : this.relationshipByEntityType.keySet()) {
            SchemeRelationship schemeRelationship = (SchemeRelationship)this.relationshipByEntityType.get(key);
            Set allSchemeEntities = schemeRelationship.getAllSchemeEntities();
            if (allSchemeEntities == null) continue;
            ret.addAll(allSchemeEntities);
        }
        return ret;
    }

    private Set getAllMatchingSchemeEntities() {
        HashSet ret = new HashSet();
        for (Object key : this.relationshipByEntityType.keySet()) {
            SchemeRelationship schemeRelationship = (SchemeRelationship)this.relationshipByEntityType.get(key);
            Collection matchingSchemeEntities = schemeRelationship.getMatchingSchemeEntities();
            if (matchingSchemeEntities == null) continue;
            ret.addAll(matchingSchemeEntities);
        }
        return ret;
    }
}

