/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JiraWebResourceManagerImpl
extends WebResourceManagerImpl
implements JiraWebResourceManager {
    private static final Logger log = Logger.getLogger(JiraWebResourceManagerImpl.class);
    private static final String REQUEST_CACHE_METADATA_ADDED = "jira.metadata.added";
    private static final String REQUEST_CACHE_METADATA_KEY = "jira.metadata.map";
    private String staticBaseUrl;

    public JiraWebResourceManagerImpl(ApplicationProperties appProps, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        super(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration);
        String cdn = appProps.getDefaultBackedString("jira.cdn.static.prefix");
        if (cdn != null) {
            if (cdn.endsWith("/")) {
                cdn = cdn.substring(0, cdn.length() - 1);
            }
            log.info((Object)("CDN static prefix in use, prefix=" + cdn));
        }
        this.staticBaseUrl = cdn;
    }

    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        if (this.staticBaseUrl != null) {
            return this.staticBaseUrl + super.getStaticResourcePrefix(resourceCounter, UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    public String getStaticResourcePrefix(UrlMode urlMode) {
        if (this.staticBaseUrl != null) {
            return this.staticBaseUrl + super.getStaticResourcePrefix(UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(urlMode);
    }

    public boolean putMetadata(String key, String value) {
        Map cache = this.webResourceIntegration.getRequestCache();
        if (cache.get(REQUEST_CACHE_METADATA_ADDED) != null) {
            log.debug((Object)("Web Metadata already retrieved for this request - could not add key/value pair: '" + key + "' / '" + value + "'"));
            return false;
        }
        this.getMetadataMap().put(key, value);
        return true;
    }

    public Map<String, String> getMetadata() {
        Map cache = this.webResourceIntegration.getRequestCache();
        if (cache.get(REQUEST_CACHE_METADATA_ADDED) != null) {
            log.warn((Object)"Web Metadata cannot be retrieved more than once in a request");
            return Collections.emptyMap();
        }
        cache.put(REQUEST_CACHE_METADATA_ADDED, true);
        return this.getMetadataMap();
    }

    private Map<String, String> getMetadataMap() {
        Map cache = this.webResourceIntegration.getRequestCache();
        LinkedHashMap metadataMap = (LinkedHashMap)cache.get(REQUEST_CACHE_METADATA_KEY);
        if (metadataMap == null) {
            metadataMap = new LinkedHashMap();
            cache.put(REQUEST_CACHE_METADATA_KEY, metadataMap);
        }
        return metadataMap;
    }
}

