/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.contextproviders;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;

public class HeightContextProvider
extends AbstractJiraContextProvider {
    private final ApplicationProperties applicationProperties;
    private final UserIssueHistoryManager userHistoryManager;

    public HeightContextProvider(ApplicationProperties applicationProperties, UserIssueHistoryManager userHistoryManager) {
        this.applicationProperties = applicationProperties;
        this.userHistoryManager = userHistoryManager;
    }

    public Map getContextMap(User user, JiraHelper jiraHelper) {
        List history = this.userHistoryManager.getShortIssueHistory(user);
        int logoHeight = TextUtils.parseInt((String)this.applicationProperties.getDefaultBackedString("jira.lf.logo.height"));
        String historyHeight = String.valueOf(80 + logoHeight + 25 * history.size());
        String filterHeight = String.valueOf(205 + logoHeight);
        return EasyMap.build((Object)"historyWindowHeight", (Object)historyHeight, (Object)"filtersWindowHeight", (Object)filterHeight);
    }
}

