/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview.auth;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.StringUtils;

class SearchResultSizeAuthorizer
implements Authorizer {
    private final SearchProvider searchProvider;
    private final long maxAllowed;
    private final Authorizer delegate;

    SearchResultSizeAuthorizer(SearchProvider searchProvider, long maxAllowed, Authorizer delegate) {
        Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        Assertions.notNull((String)"delegate", (Object)delegate);
        if (maxAllowed < 0L) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be configured with a negative maxAllowed: '" + maxAllowed + "'");
        }
        this.searchProvider = searchProvider;
        this.maxAllowed = maxAllowed;
        this.delegate = delegate;
    }

    public Authorizer.Result isSearchRequestAuthorized(User user, SearchRequest searchRequest, SearchRequestParams params) {
        if (this.getSearchCount(user, searchRequest, params) > this.maxAllowed) {
            return new Authorizer.Failure("You are not allowed to get a result set of more than " + this.maxAllowed + " results. Current search returns " + this.getSearchCount(user, searchRequest, params) + " results");
        }
        return this.delegate.isSearchRequestAuthorized(user, searchRequest, params);
    }

    private long getSearchCount(User user, SearchRequest searchRequest, SearchRequestParams params) {
        if (params != null) {
            String searchCount = String.valueOf(params.getSession().get("searchCount"));
            long resultCount = StringUtils.isNumeric((String)searchCount) ? Long.parseLong(searchCount) : this.getSearchCountFromSearchProvider(user, searchRequest);
            if (params.getPagerFilter() != null) {
                return Math.min(resultCount, (long)params.getPagerFilter().getMax());
            }
            return resultCount;
        }
        return this.getSearchCountFromSearchProvider(user, searchRequest);
    }

    private long getSearchCountFromSearchProvider(User user, SearchRequest searchRequest) {
        try {
            return this.searchProvider.searchCount(searchRequest == null ? null : searchRequest.getQuery(), user);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    Authorizer getDelegate() {
        return this.delegate;
    }

    long getMaxAllowed() {
        return this.maxAllowed;
    }
}

