/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview;

import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SearchRequestParamsImpl
implements SearchRequestParams {
    private Map sessionParamsMap;
    private PagerFilter pagerFilter;
    private IssueViewFieldParams issueViewFieldParams;
    private String userAgent;

    public SearchRequestParamsImpl(HttpSession session) {
        this.sessionParamsMap = this.convertSessionToMap(session);
        this.pagerFilter = PagerFilter.getUnlimitedFilter();
    }

    public SearchRequestParamsImpl(HttpSession session, PagerFilter pagerFilter) {
        this(session, pagerFilter, null, null);
    }

    public SearchRequestParamsImpl(Map params, PagerFilter pagerFilter) {
        this.sessionParamsMap = new HashMap();
        if (params != null) {
            this.sessionParamsMap.putAll(params);
        }
        this.pagerFilter = pagerFilter;
    }

    public SearchRequestParamsImpl(HttpSession session, PagerFilter pagerFilter, IssueViewFieldParams issueViewFieldParams) {
        this(session, pagerFilter, null, issueViewFieldParams);
    }

    public SearchRequestParamsImpl(HttpSession session, PagerFilter pagerFilter, Map otherParams, IssueViewFieldParams issueViewFieldParams) {
        this(session, pagerFilter, otherParams, issueViewFieldParams, null);
    }

    public SearchRequestParamsImpl(HttpSession session, PagerFilter pagerFilter, Map otherParams, IssueViewFieldParams issueViewFieldParams, String userAgent) {
        this.issueViewFieldParams = issueViewFieldParams;
        this.sessionParamsMap = this.convertSessionToMap(session);
        if (otherParams != null && !otherParams.isEmpty()) {
            this.sessionParamsMap.putAll(otherParams);
        }
        this.pagerFilter = pagerFilter;
        this.userAgent = userAgent;
    }

    private Map convertSessionToMap(HttpSession session) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            map.put(attributeName, session.getAttribute(attributeName));
        }
        return map;
    }

    public Map getSession() {
        return Collections.unmodifiableMap(this.sessionParamsMap);
    }

    public PagerFilter getPagerFilter() {
        return this.pagerFilter;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public IssueViewFieldParams getIssueViewFieldParams() {
        return this.issueViewFieldParams;
    }
}

