/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.browsepanel;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.TabPanelModuleDescriptor;
import com.atlassian.jira.plugin.browsepanel.TabPanel;
import com.atlassian.jira.plugin.projectpanel.fragment.MenuFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFragmentBasedTabPanel<D extends TabPanelModuleDescriptor, C extends BrowseContext, F extends ProjectTabPanelFragment>
implements TabPanel<D, C> {
    protected D moduleDescriptor;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractFragmentBasedTabPanel.class);

    public void init(D descriptor) {
        this.moduleDescriptor = descriptor;
    }

    public String getHtml(C ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPageHeaderHtml(ctx));
        this.createContent(ctx, sb);
        return sb.toString();
    }

    protected String getPageHeaderHtml(C ctx) {
        StringBuilder sb = new StringBuilder();
        StringBuilder actions = new StringBuilder();
        HashMap<String, String> data = new HashMap<String, String>();
        List<MenuFragment> menuFrags = this.getMenuFragments();
        String inlineHeader = this.getInlineHeader();
        if (!menuFrags.isEmpty()) {
            actions.append("<div id=\"quicklinks\">\n");
            actions.append("<ul class=\"operations\">\n");
            for (MenuFragment menuFragment : menuFrags) {
                if (!menuFragment.showFragment((BrowseContext)ctx)) continue;
                actions.append("<li class=\"aui-dd-parent\">\n");
                actions.append(menuFragment.getHtml((BrowseContext)ctx));
                actions.append("</li>\n");
            }
            actions.append("</div>");
            data.put("actionsContent", actions.toString());
        }
        if (StringUtils.isNotBlank((String)inlineHeader)) {
            data.put("mainContent", "<h2>" + inlineHeader + "</h2>");
        }
        try {
            if (!data.isEmpty()) {
                data.put("tagName", "div");
                if (!data.containsKey("mainContent")) {
                    data.put("mainContent", "");
                }
                sb.append(this.getSoyRenderer().render("jira.webresources:soy-templates", "JIRA.Templates.Headers.pageHeader", data));
            }
        }
        catch (SoyException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to render page header template", (Throwable)e);
            }
            sb.append(data.get("actionsContent"));
            sb.append(data.get("mainContent"));
        }
        return sb.toString();
    }

    protected SoyTemplateRenderer getSoyRenderer() {
        return ComponentManager.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
    }

    public String getInlineHeader() {
        return null;
    }

    private void createContent(C ctx, StringBuilder sb) {
        StringBuilder leftcolSb = new StringBuilder();
        boolean hasLeftContent = this.createColumnContent(ctx, leftcolSb, this.getLeftColumnFragments(ctx));
        StringBuilder rightcolSb = new StringBuilder();
        boolean hasRightContent = this.createColumnContent(ctx, rightcolSb, this.getRightColumnFragments(ctx));
        StringBuilder topSb = new StringBuilder();
        boolean hasTopContent = this.createColumnContent(ctx, topSb, this.getTopFragments(ctx));
        sb.append("<div class=\"tabpanel-modules\">");
        if (hasTopContent) {
            sb.append("    <div class=\"tabpanel-modules-top\">");
            sb.append((CharSequence)topSb);
            sb.append("    </div>");
        }
        sb.append("    <div class=\"aui-group tabpanel-modules-split\">");
        if (hasLeftContent) {
            sb.append("        <div class=\"aui-item\">");
            sb.append((CharSequence)leftcolSb);
            sb.append("        </div>");
        }
        if (hasRightContent) {
            sb.append("        <div class=\"aui-item\">");
            sb.append((CharSequence)rightcolSb);
            sb.append("        </div>");
        }
        if (!hasLeftContent && !hasRightContent) {
            sb.append("        <div class=\"aui-item\">");
            sb.append(this.createEmptyContent());
            sb.append("        </div>");
        }
        sb.append("    </div>");
        sb.append("</div>");
    }

    public String createEmptyContent() {
        return this.moduleDescriptor.getI18nBean().getText("browseproject.empty.tab.generic");
    }

    private boolean createColumnContent(C ctx, StringBuilder sb, List<F> columnFragments) {
        boolean hasAtleastOneFrag = false;
        for (ProjectTabPanelFragment fragment : columnFragments) {
            hasAtleastOneFrag = this.appendFragmentIfVisible(ctx, sb, fragment) || hasAtleastOneFrag;
        }
        return hasAtleastOneFrag;
    }

    private boolean appendFragmentIfVisible(C ctx, StringBuilder sb, F fragment) {
        if (fragment.showFragment((BrowseContext)ctx)) {
            sb.append("<div class=\"module\" id=\"frag").append(fragment.getId()).append("\">");
            sb.append(fragment.getHtml((BrowseContext)ctx));
            sb.append("</div>");
            return true;
        }
        return false;
    }

    protected List<F> getTopFragments(C ctx) {
        return Collections.emptyList();
    }

    protected abstract List<F> getLeftColumnFragments(C var1);

    protected abstract List<F> getRightColumnFragments(C var1);

    protected List<MenuFragment> getMenuFragments() {
        return Collections.emptyList();
    }

    public boolean showPanel(C context) {
        return !this.getLeftColumnFragments(context).isEmpty() || !this.getRightColumnFragments(context).isEmpty();
    }
}

