/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.JiraFailedPluginTracker;
import com.atlassian.jira.plugin.JiraPluginSystemListener;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.plugin.PluginVersionImpl;
import com.atlassian.jira.plugin.PluginVersionStore;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.exception.PluginExceptionInterception;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.picocontainer.MutablePicoContainer;

public class JiraPluginManager
extends DefaultPluginManager
implements Startable {
    public static final String PLUGIN_LICENSE_REGISTRY = "plugin-license-registry-location";
    public static final String PLUGIN_LICENSE_TYPE_STORE = "plugin-license-store-location";
    private static final Logger log = Logger.getLogger(JiraPluginManager.class);
    private final PluginVersionStore pluginVersionStore;
    private final JiraPluginSystemListener jiraPluginSystemListener;

    public JiraPluginManager(PluginPersistentStateStore store, PluginLoaderFactory pluginLoaderFactory, ModuleDescriptorFactory moduleDescriptorFactory, PluginVersionStore pluginVersionStore, PluginEventManager pluginEventManager, PluginPath pluginPath, JiraPluginSystemListener jiraPluginSystemListener, JiraFailedPluginTracker failedPluginTracker) {
        super(store, pluginLoaderFactory.getPluginLoaders(), moduleDescriptorFactory, pluginEventManager, (PluginExceptionInterception)failedPluginTracker);
        this.pluginVersionStore = pluginVersionStore;
        this.jiraPluginSystemListener = jiraPluginSystemListener;
        this.setPluginInstaller((PluginInstaller)new FilePluginInstaller(pluginPath.getInstalledPluginsDirectory()));
    }

    public void start() throws PluginException {
        Logger startUpLogger = JiraStartupLogger.log();
        startUpLogger.info((Object)"\n\n___ Starting the JIRA Plugin System _________________\n");
        this.init();
        this.storePluginVersions();
        startUpLogger.info((Object)"\n\n___ Plugin System Started _________________\n");
    }

    public void enablePlugins(String ... keys) {
        super.enablePlugins(keys);
        for (String key : keys) {
            this.processEnabledPlugin(key);
        }
    }

    @PluginEventListener
    public void onPluginEnabledEvent(PluginEnabledEvent enabledEvent) {
        Plugin plugin = enabledEvent.getPlugin();
        log.debug((Object)String.format("Plugin with key '%s' has been enabled.", plugin.getKey()));
        this.pluginVersionStore.save(new PluginVersionImpl(plugin.getKey(), plugin.getName(), plugin.getPluginInformation().getVersion(), new Date()));
    }

    @PluginEventListener
    public void onPluginUninstalledEvent(PluginUninstalledEvent uninstalledEvent) {
        Plugin plugin = uninstalledEvent.getPlugin();
        log.debug((Object)String.format("Plugin with key '%s' has been uninstalled.", plugin.getKey()));
        this.pluginVersionStore.deleteByKey(plugin.getKey());
    }

    @PluginEventListener
    public void onPluginDisabledEvent(PluginDisabledEvent disabledEvent) {
        Plugin plugin = disabledEvent.getPlugin();
        log.debug((Object)String.format("Plugin with key '%s' has been disabled.", plugin.getKey()));
    }

    private void processEnabledPlugin(String key) {
        Plugin plugin = this.getPlugin(key);
        if (plugin != null) {
            Collection funNewComponents = this.getPlugin(key).getModuleDescriptors();
            if (!funNewComponents.isEmpty()) {
                for (ModuleDescriptor moduleDescriptor : funNewComponents) {
                    if (!ComponentModuleDescriptor.class.isInstance(moduleDescriptor) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                    ComponentModuleDescriptor componentModuleDescriptor = (ComponentModuleDescriptor)moduleDescriptor;
                    componentModuleDescriptor.registerComponents(ComponentManager.getInstance().getMutablePicoContainer());
                }
            }
        } else {
            log.error((Object)("Could not enable plugin with key '" + key + "'"));
        }
    }

    public void disablePlugin(String key) {
        this.unregisterComponents(key);
        super.disablePlugin(key);
        if (!ComponentManager.getInstance().getState().isPluginSystemStarted()) {
            log.warn((Object)("Disable Plugin with key '" + key + "' called before Plugin System Started."), (Throwable)new RuntimeException());
        }
    }

    public void disablePluginWithoutPersisting(String key) {
        this.unregisterComponents(key);
        super.disablePluginWithoutPersisting(key);
        if (ComponentManager.getInstance().getState().isPluginSystemStarted() && log.isDebugEnabled()) {
            log.debug((Object)("Disabling plugin with key  '" + key + "' without persisting. This should occur if this " + "plugin depends on a plugin that is currently being upgraded"));
        }
    }

    private void unregisterComponents(String key) {
        Plugin plugin = this.getPlugin(key);
        if (plugin == null) {
            log.warn((Object)String.format("Attempted to unregister components for non existing plugin '%s'", key));
            return;
        }
        Collection funNewComponents = plugin.getModuleDescriptors();
        if (!funNewComponents.isEmpty()) {
            for (ModuleDescriptor moduleDescriptor : funNewComponents) {
                if (!ComponentModuleDescriptor.class.isInstance(moduleDescriptor) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                ComponentModuleDescriptor componentModuleDescriptor = (ComponentModuleDescriptor)moduleDescriptor;
                componentModuleDescriptor.unregisterComponents(ComponentManager.getInstance().getMutablePicoContainer());
            }
        }
    }

    public void disablePluginModule(String completeKey) {
        ModuleDescriptor moduleDescriptor = this.getEnabledPluginModule(completeKey);
        if (moduleDescriptor instanceof ComponentModuleDescriptor) {
            ((ComponentModuleDescriptor)moduleDescriptor).unregisterComponents((MutablePicoContainer)ComponentManager.getInstance().getContainer());
        }
        super.disablePluginModule(completeKey);
    }

    public void enablePluginModule(String completeKey) {
        super.enablePluginModule(completeKey);
        ModuleDescriptor moduleDescriptor = this.getEnabledPluginModule(completeKey);
        if (moduleDescriptor instanceof ComponentModuleDescriptor) {
            ((ComponentModuleDescriptor)moduleDescriptor).registerComponents((MutablePicoContainer)ComponentManager.getInstance().getContainer());
        }
    }

    void storePluginVersions() {
        Map<String, PluginVersion> pluginVersionsByKey = this.getPluginVersionsByKey();
        for (Plugin plugin : this.getPlugins()) {
            this.storePluginVersion(plugin, pluginVersionsByKey.get(plugin.getKey()));
            pluginVersionsByKey.remove(plugin.getKey());
        }
        this.deletePluginVersions(pluginVersionsByKey.values());
    }

    void storePluginVersion(Plugin plugin, PluginVersion pluginVersion) {
        String pluginKey = plugin.getKey();
        PluginInformation pluginInformation = plugin.getPluginInformation();
        String version = "unknown";
        if (pluginInformation != null) {
            version = pluginInformation.getVersion();
        }
        if (pluginVersion == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Plugin with key '" + pluginKey + "' and name '" + plugin.getName() + "' and version '" + version + "' is being added to the system."));
            }
            this.pluginVersionStore.create(new PluginVersionImpl(pluginKey, plugin.getName(), version, new Date()));
        } else if (!pluginVersion.getVersion().equals(version)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Plugin with key '" + pluginKey + "' and name '" + plugin.getName() + "' and version '" + pluginVersion.getVersion() + "' is being updated to version '" + version + "'."));
            }
            this.pluginVersionStore.update(new PluginVersionImpl(pluginVersion.getId(), pluginVersion.getKey(), plugin.getName(), version, new Date()));
        }
    }

    void deletePluginVersions(Collection<PluginVersion> pluginVersionsToDelete) {
        for (PluginVersion pluginVersion : pluginVersionsToDelete) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Plugin with key '" + pluginVersion.getKey() + "' and name '" + pluginVersion.getName() + "' and version '" + pluginVersion.getVersion() + "' is being removed from the system."));
            }
            this.pluginVersionStore.delete(pluginVersion.getId());
        }
    }

    Map<String, PluginVersion> getPluginVersionsByKey() {
        HashMap<String, PluginVersion> versionsByKey = new HashMap<String, PluginVersion>();
        List<PluginVersion> pluginVersions = this.pluginVersionStore.getAll();
        for (PluginVersion pluginVersion : pluginVersions) {
            versionsByKey.put(pluginVersion.getKey(), pluginVersion);
        }
        return versionsByKey;
    }
}

