/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.workflow.WorkflowUtil;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWorkflowPermission
implements WorkflowPermission {
    public static final String PREFIX = "jira.permission.";
    public static final String PREFIX_PARENT = "jira.permission.subtasks.";
    int permission;
    SecurityType grantType;
    String value;
    private boolean parentPermission;

    protected DefaultWorkflowPermission(int permission, SecurityType grantType, String value, boolean isParentPermission) {
        this.permission = permission;
        this.grantType = grantType;
        this.value = value;
        this.parentPermission = isParentPermission;
    }

    @Override
    public Set getUsers(PermissionContext ctx) {
        return this.grantType.getUsers(ctx, this.getValueFor(ctx.getIssue()));
    }

    @Override
    public boolean allows(int permission, Issue issue, User user) {
        if (user == null) {
            return this.grantType.hasPermission(issue, this.getValueFor(issue));
        }
        return this.grantType.hasPermission(issue, this.getValueFor(issue), user, false);
    }

    public String toString() {
        return (this.parentPermission ? "parent " : "") + "workflow perm granting " + Permissions.getShortName((int)this.permission) + " to " + this.grantType.getDisplayName() + " '" + this.value + "'";
    }

    private String getValueFor(Issue issue) {
        GenericValue project = issue.getProject();
        return WorkflowUtil.interpolateProjectKey((GenericValue)project, (String)this.value);
    }
}

