/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.JiraKeyUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

class IssueGenericValue
extends GenericValue {
    private static final Logger log = Logger.getLogger(IssueGenericValue.class);

    IssueGenericValue(GenericValue genericValue) {
        super(genericValue);
    }

    public Object get(String name) {
        if ("key".equals(name)) {
            Long issueNumber = super.getLong("number");
            if (issueNumber != null) {
                Long projectId = this.getLong("project");
                if (projectId == null) {
                    log.warn((Object)String.format("Issue (id=%d) has empty field 'project'. Returning null for 'key'.", this.getLong("id")));
                    return null;
                }
                Project project = ComponentAccessor.getProjectManager().getProjectObj(projectId);
                if (project == null) {
                    log.warn((Object)String.format("Issue (id=%d) has field 'project' of value %d, but no project with this id can be found. Returning null for 'key'.", this.getLong("id"), projectId));
                    return null;
                }
                return JiraKeyUtils.fastFormatIssueKey((String)project.getKey(), (Long)issueNumber);
            }
            Object key = super.get("key");
            if (key == null) {
                log.warn((Object)String.format("Issue (id=%d) has empty field 'num'. Returning null for 'key'.", this.getLong("id")));
                return null;
            }
            return key;
        }
        return super.get(name);
    }

    public void set(String name, Object value) {
        if ("key".equals(name)) {
            if (value == null) {
                throw new NullPointerException("One can not set 'key' to null for Issue entity because its mapped to 'number' and no sensible value can be derived from null.");
            }
            super.set("number", (Object)JiraKeyUtils.getFastCountFromKey((String)((String)value)));
        } else {
            super.set(name, value);
        }
    }
}

