/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.notification.type.ApplicationUserToRecipient;
import com.atlassian.jira.notification.type.UserCFNotificationTypeAware;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserCFValue
extends AbstractNotificationType {
    public static final String ID = "User_Custom_Field_Value";
    private static final Logger log = Logger.getLogger(UserCFValue.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FieldManager fieldManager;

    public UserCFValue(JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager) {
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)jiraAuthenticationContext);
        this.fieldManager = (FieldManager)Assertions.notNull((Object)fieldManager);
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        try {
            Object recipients = this.getRecipientsObject(event, argument);
            List<ApplicationUser> users = this.convertToUsers(recipients);
            return Lists.transform(users, (Function)ApplicationUserToRecipient.INSTANCE);
        }
        catch (Exception e) {
            log.warn((Object)"Exception occurred while working out recipients from a custom field value. Returning empty list.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Object getRecipientsObject(IssueEvent event, String argument) {
        Object answer = this.getFromEventParams(event, argument);
        if (answer != null) {
            return answer;
        }
        Issue issue = event.getIssue();
        CustomField field = this.getField(argument);
        if (field != null && field.isInScope(issue.getProjectObject(), (List)ImmutableList.of((Object)issue.getIssueTypeObject().getId()))) {
            return field.getValue(issue);
        }
        return null;
    }

    private List<ApplicationUser> convertToUsers(Object recipients) {
        Object users = recipients instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)recipients)) : (recipients instanceof ApplicationUser ? ImmutableList.of((Object)((ApplicationUser)recipients)) : Collections.emptyList());
        return users;
    }

    private Object getFromEventParams(IssueEvent event, String argument) {
        Map customFields = (Map)event.getParams().get(IssueEvent.CUSTOM_FIELDS_PARAM_NAME);
        if (customFields == null) {
            return null;
        }
        return customFields.get(argument);
    }

    private CustomField getField(String argument) {
        try {
            return this.fieldManager.getCustomField(argument);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Error while retrieving custom field. Returning empty list of e-mail recipients. Please remove any invalid custom fields from your notification schemes.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.user.custom.field.value");
    }

    @Override
    public String getType() {
        return "userCF";
    }

    public List<NavigableField> getFields() {
        Set fieldSet;
        ArrayList<NavigableField> fields = new ArrayList<NavigableField>();
        try {
            fieldSet = this.fieldManager.getAllAvailableNavigableFields();
        }
        catch (FieldException e) {
            return Collections.emptyList();
        }
        for (NavigableField field : fieldSet) {
            CustomField customField;
            if (!this.fieldManager.isCustomField((Field)field) || !((customField = (CustomField)field).getCustomFieldType() instanceof UserCFNotificationTypeAware)) continue;
            fields.add(field);
        }
        return fields;
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        String value = (String)parameters.get(key);
        if (value == null || value.length() == 0) {
            return false;
        }
        try {
            this.fieldManager.getCustomField(value);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    @Override
    public String getArgumentDisplay(String argument) {
        CustomField field = this.fieldManager.getCustomField(argument);
        return field.getName();
    }
}

