/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.jira.mail.BotocssMailUtility;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class BotocssMailUtilityImpl
implements BotocssMailUtility {
    private final BotocssStyles botocssStyles;
    private final List<String> cssFilenames = ImmutableList.builder().add((Object)"templates/email/css/mail-css.css").add((Object)"templates/email/css/mail-css2.css").build();

    public BotocssMailUtilityImpl() {
        this.botocssStyles = this.getBotocssStyles();
    }

    private BotocssStyles getBotocssStyles() {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream stream = null;
        for (String filename : this.cssFilenames) {
            try {
                stream = (InputStream)Preconditions.checkNotNull((Object)this.getClass().getClassLoader().getResourceAsStream(filename));
                stringBuilder.append(IOUtils.toString((InputStream)stream, (String)"UTF-8"));
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        return BotocssStyles.parse((String[])new String[]{stringBuilder.toString()});
    }

    public String applyStyles(String html) {
        return Botocss.inject((String)html, (BotocssStyles)this.botocssStyles);
    }
}

