/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@InjectableComponent
public class ProjectResolver
implements NameResolver<Project> {
    private final ProjectManager projectManager;

    public ProjectResolver(ProjectManager projectManager) {
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
    }

    public List<String> getIdsFromName(String name) {
        Assertions.notNull((String)"name", (Object)name);
        Project project = this.projectManager.getProjectByCurrentKeyIgnoreCase(name);
        if (project == null) {
            project = this.projectManager.getProjectObjByName(name);
        }
        if (project != null) {
            return Collections.singletonList(project.getId().toString());
        }
        return Collections.emptyList();
    }

    public boolean nameExists(String name) {
        Assertions.notNull((String)"name", (Object)name);
        Project project = this.projectManager.getProjectByCurrentKeyIgnoreCase(name);
        if (project == null) {
            project = this.projectManager.getProjectObjByName(name);
        }
        return project != null;
    }

    public boolean idExists(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        Project project = this.projectManager.getProjectObj(id);
        return project != null;
    }

    public Project get(Long id) {
        return this.projectManager.getProjectObj(id);
    }

    public Collection<Project> getAll() {
        return this.projectManager.getProjectObjects();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectResolver that = (ProjectResolver)o;
        return this.projectManager.equals(that.projectManager);
    }

    public int hashCode() {
        return this.projectManager.hashCode();
    }
}

