/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueUtilsBean;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.tag.JellyUtils;
import com.atlassian.jira.jelly.tag.issue.CustomFieldValuesAwareTag;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class TransitionWorkflow
extends JiraDynaBeanTagSupport
implements CustomFieldValuesAwareTag {
    private static final String KEY_USER = "user";
    private static final String KEY_ISSUE_KEY = "key";
    private static final String KEY_WORKFLOW_ACTION = "workflowAction";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_GROUP_COMMENT_LEVEL = "groupLevel";
    private static final String KEY_ROLE_COMMENT_LEVEL = "roleLevel";
    public static final Set<String> attributes;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueManager issueManager;
    private final IssueUtilsBean issueUtilsBean;
    private final WorkflowManager workflowManager;
    private final FieldManager fieldManager;
    private final IssueFactory issueFactory;

    public TransitionWorkflow(JiraAuthenticationContext authenticationContext, IssueManager issueManager, WorkflowManager workflowManager, FieldManager fieldManager, IssueFactory issueFactory, IssueUtilsBean issueUtilsBean) {
        this.authenticationContext = authenticationContext;
        this.issueManager = issueManager;
        this.workflowManager = workflowManager;
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
        this.issueUtilsBean = issueUtilsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        if (this.getBody() != null) {
            this.getBody().run(this.getContext(), xmlOutput);
        }
        this.validateAttributes();
        User user = this.getUser();
        MutableIssue issue = this.getIssue();
        int actionId = this.getActionId((Issue)issue).getId();
        Map<String, Object> requestCacheContents = JiraAuthenticationContextImpl.getRequestCache();
        User previousUser = this.authenticationContext.getLoggedInUser();
        try {
            this.authenticationContext.setLoggedInUser(user);
            JiraAuthenticationContextImpl.clearRequestCache();
            WorkflowTransitionUtil workflowTransitionUtil = JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
            workflowTransitionUtil.setIssue(issue);
            workflowTransitionUtil.setAction(actionId);
            Map params = this.getTransitionParameters(workflowTransitionUtil, (Issue)issue);
            workflowTransitionUtil.setParams(params);
            JellyUtils.processErrorCollection(workflowTransitionUtil.validate());
            JellyUtils.processErrorCollection(workflowTransitionUtil.progress());
        }
        finally {
            this.authenticationContext.setLoggedInUser(previousUser);
            JiraAuthenticationContextImpl.clearRequestCache();
            if (requestCacheContents != null) {
                JiraAuthenticationContextImpl.getRequestCache().putAll(requestCacheContents);
            }
            this.restoreProperties();
        }
    }

    private ActionDescriptor getActionId(Issue issue) throws JellyTagException {
        try {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(issue.getGenericValue());
            try {
                int actionId = Integer.parseInt(this.getWorkflowActionProperty());
                ActionDescriptor action = workflow.getDescriptor().getAction(actionId);
                if (action == null) {
                    throw new JellyTagException("Invalid action id '" + this.getWorkflowActionProperty() + "'.");
                }
                this.validateActionForIssuesState(issue, action);
                return action;
            }
            catch (NumberFormatException e) {
                return this.getActionByName(workflow, issue);
            }
        }
        catch (WorkflowException e) {
            throw new JellyTagException("Error occurred while retrieving workflow for issue with key '" + this.getKey() + "'", (Throwable)e);
        }
    }

    private MutableIssue getIssue() throws JellyTagException {
        MutableIssue issue;
        try {
            GenericValue issueGV = this.issueManager.getIssue(this.getKey());
            if (issueGV == null) {
                throw new JellyTagException("Cannot retrieve issue with key '" + this.getKey() + "'");
            }
            issue = this.getIssueObject(issueGV);
        }
        catch (GenericEntityException e) {
            throw new JellyTagException("Error occurred while retrieving issue with key '" + this.getKey() + "'", (Throwable)e);
        }
        return issue;
    }

    private void validateActionForIssuesState(Issue issue, ActionDescriptor action) throws JellyTagException {
        if (!this.issueUtilsBean.isValidAction(issue, action.getId())) {
            throw new JellyTagException(this.getFoundButNotValidMessage(String.valueOf(action.getId()), issue));
        }
    }

    private String getFoundButNotValidMessage(String actionName, Issue issue) {
        return "Found workflow transition with name/id '" + actionName + "' but that is not a valid workflow transition for the current state of issue '" + issue.getKey() + "'.";
    }

    public MutableIssue getIssueObject(GenericValue issueGV) {
        return this.issueFactory.getIssue(issueGV);
    }

    private Map getTransitionParameters(WorkflowTransitionUtil workflowTransitionUtil, Issue issue) throws JellyTagException {
        HashMap<String, String> workflowTransitionParams = new HashMap<String, String>();
        if (this.paramSpecified(KEY_COMMENT)) {
            workflowTransitionParams.put(KEY_COMMENT, this.getComment());
            if (this.paramSpecified(KEY_GROUP_COMMENT_LEVEL)) {
                workflowTransitionParams.put("commentLevel", this.getGroupCommentLevel());
            }
            if (this.paramSpecified(KEY_ROLE_COMMENT_LEVEL)) {
                workflowTransitionParams.put(KEY_ROLE_COMMENT_LEVEL, this.getProjectRoleId(this.getRoleCommentLevel(), this.getUser(), (ErrorCollection)new SimpleErrorCollection()));
            }
        }
        if (workflowTransitionUtil.hasScreen()) {
            for (FieldScreenRenderTab fieldScreenRenderTab : workflowTransitionUtil.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                    if (!fieldScreenRenderLayoutItem.isShow(issue)) continue;
                    OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                    orderableField.populateFromIssue(workflowTransitionParams, issue);
                    if (!this.getProperties().containsKey(orderableField.getId())) continue;
                    if (this.fieldManager.isCustomField((Field)orderableField)) {
                        HashMap<String, String[]> actionParams = new HashMap<String, String[]>();
                        for (Object o : this.getProperties().keySet()) {
                            String key = (String)o;
                            if (!key.startsWith(orderableField.getId())) continue;
                            List values = (List)this.getProperties().get(key);
                            actionParams.put(key, values.toArray(new String[values.size()]));
                        }
                        orderableField.populateFromParams(workflowTransitionParams, actionParams);
                        continue;
                    }
                    try {
                        orderableField.populateParamsFromString(workflowTransitionParams, (String)this.getProperties().get(orderableField.getId()), issue);
                    }
                    catch (FieldValidationException e) {
                        throw new JellyTagException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return workflowTransitionParams;
    }

    private User getUser() throws JellyTagException {
        String username = this.paramSpecified(KEY_USER) ? this.getUsername() : (String)this.getContext().getVariable("jelly.username");
        User user = TextUtils.stringSet((String)username) ? UserUtils.getUser((String)username) : null;
        return user;
    }

    private String getProjectRoleId(String roleLevel, User user, ErrorCollection errorCollection) throws JellyTagException {
        ProjectRoleService projectRoleService = (ProjectRoleService)ComponentAccessor.getComponentOfType(ProjectRoleService.class);
        Long roleLevelId = null;
        if (roleLevel != null) {
            try {
                roleLevelId = new Long(roleLevel);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (roleLevelId == null) {
                ProjectRole projectRole = projectRoleService.getProjectRoleByName(roleLevel, errorCollection);
                if (projectRole != null && !errorCollection.hasAnyErrors()) {
                    roleLevelId = projectRole.getId();
                } else {
                    throw new JellyTagException("ProjectRole level not found: " + roleLevel);
                }
            }
        }
        return roleLevelId == null ? null : roleLevelId.toString();
    }

    private void validateAttributes() throws JellyTagException {
        User assignee;
        if (!this.paramSpecified(KEY_ISSUE_KEY) || !TextUtils.stringSet((String)this.getKey())) {
            throw new MissingAttributeException(KEY_ISSUE_KEY);
        }
        if (!this.paramSpecified(KEY_WORKFLOW_ACTION) || !TextUtils.stringSet((String)this.getWorkflowActionProperty())) {
            throw new MissingAttributeException(KEY_WORKFLOW_ACTION);
        }
        MutableIssue issue = this.getIssue();
        ActionDescriptor actionDescriptor = this.getActionId((Issue)issue);
        WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
        FieldScreen fieldScreen = workflowActionsBean.getFieldScreenForView(actionDescriptor);
        if (!this.getProperties().keySet().contains("assignee") && fieldScreen != null && fieldScreen.containsField("assignee") && (assignee = issue.getAssignee()) != null) {
            this.getProperties().put("assignee", assignee.getName());
        }
        for (Object o : this.getProperties().keySet()) {
            String attributeName = (String)o;
            if (attributes.contains(attributeName)) continue;
            String fieldId = attributeName;
            int index = attributeName.indexOf(":");
            if (index > -1) {
                fieldId = attributeName.substring(0, index);
            }
            if (!this.fieldManager.isOrderableField(fieldId)) {
                throw new JellyTagException("Invalid attribute '" + attributeName + "'.");
            }
            if (fieldScreen == null) {
                throw new JellyTagException("Field '" + attributeName + "' can not be set on action with no screen");
            }
            if (fieldScreen.containsField(fieldId)) continue;
            throw new JellyTagException("Field '" + attributeName + "' is not present on screen '" + fieldScreen.getName() + "'.");
        }
    }

    private ActionDescriptor getActionByName(JiraWorkflow workflow, Issue issue) throws JellyTagException {
        boolean actionWithNameFound = false;
        String workflowActionProperty = this.getWorkflowActionProperty();
        for (ActionDescriptor actionDescriptor : workflow.getAllActions()) {
            if (!workflowActionProperty.equalsIgnoreCase(actionDescriptor.getName())) continue;
            if (this.issueUtilsBean.isValidAction(issue, actionDescriptor.getId())) {
                return actionDescriptor;
            }
            actionWithNameFound = true;
        }
        String errorMsg = actionWithNameFound ? this.getFoundButNotValidMessage(workflowActionProperty, issue) : "Invalid action name '" + workflowActionProperty + "'.";
        throw new JellyTagException(errorMsg);
    }

    private void restoreProperties() {
        if (this.getProperties().containsKey("assignee")) {
            this.getProperties().remove("assignee");
        }
    }

    private String getUsername() {
        return (String)this.getProperties().get(KEY_USER);
    }

    private String getKey() {
        return (String)this.getProperties().get(KEY_ISSUE_KEY);
    }

    private String getWorkflowActionProperty() {
        return (String)this.getProperties().get(KEY_WORKFLOW_ACTION);
    }

    private String getComment() {
        return (String)this.getProperties().get(KEY_COMMENT);
    }

    private String getGroupCommentLevel() {
        return (String)this.getProperties().get(KEY_GROUP_COMMENT_LEVEL);
    }

    private String getRoleCommentLevel() {
        return (String)this.getProperties().get(KEY_ROLE_COMMENT_LEVEL);
    }

    private boolean paramSpecified(String paramName) {
        return this.getProperties().containsKey(paramName);
    }

    @Override
    public void addCustomFieldValue(CustomField customField, String customFieldValue, String key) {
        String customFieldId = customField.getId();
        if (key != null) {
            this.getProperties().put(customFieldId + ":" + key, EasyList.build((Object)customFieldValue));
        } else if (this.paramSpecified(customFieldId)) {
            Collection values = (Collection)this.getProperties().get(customFieldId);
            values.add(customFieldValue);
        } else {
            this.getProperties().put(customFieldId, EasyList.build((Object)customFieldValue));
        }
    }

    static {
        HashSet<String> tmpAttributes = new HashSet<String>();
        tmpAttributes.add(KEY_USER);
        tmpAttributes.add(KEY_ISSUE_KEY);
        tmpAttributes.add(KEY_WORKFLOW_ACTION);
        tmpAttributes.add(KEY_COMMENT);
        tmpAttributes.add(KEY_GROUP_COMMENT_LEVEL);
        tmpAttributes.add(KEY_ROLE_COMMENT_LEVEL);
        attributes = Collections.unmodifiableSet(tmpAttributes);
    }
}

