/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.jelly.UserAwareDynaBeanTagSupport;
import com.atlassian.jira.jelly.tag.util.JellyTagUtils;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Date;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;

public class AddComment
extends UserAwareDynaBeanTagSupport {
    private static final String KEY_ISSUE_KEY = "issue-key";
    private static final String KEY_COMMENTER = "commenter";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_CREATED_DATE = "created";
    private static final String KEY_UPDATED_DATE = "updated";
    private static final String KEY_UPDATE_AUTHOR = "editedBy";
    private static final String KEY_GROUP_LEVEL = "groupLevel";
    private static final String KEY_ROLE_LEVEL = "roleLevel";
    private static final String KEY_TWEAK_ISSUE_UPDATE_DATE = "tweakIssueUpdateDate";

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        String commentBody = this.getPropertyByKey(KEY_COMMENT);
        String grouplevel = this.getPropertyByKey(KEY_GROUP_LEVEL);
        String roleLevel = this.getPropertyByKey(KEY_ROLE_LEVEL);
        String dateCreated = this.getPropertyByKey(KEY_CREATED_DATE);
        String issueKey = this.getPropertyByKey(KEY_ISSUE_KEY);
        String author = this.getPropertyByKey(KEY_COMMENTER);
        String updateAuthor = this.getPropertyByKey(KEY_UPDATE_AUTHOR);
        String dateUpdated = this.getPropertyByKey(KEY_UPDATED_DATE);
        String tweakIssueUpdateDateString = this.getPropertyByKey(KEY_TWEAK_ISSUE_UPDATE_DATE);
        boolean tweakIssueUpdateDate = true;
        if (author == null) {
            author = this.getUsername();
        }
        if (updateAuthor == null) {
            updateAuthor = author;
        }
        if (StringUtils.isNotBlank((String)tweakIssueUpdateDateString)) {
            tweakIssueUpdateDate = Boolean.valueOf(tweakIssueUpdateDateString);
        }
        Date created = StringUtils.isNotBlank((String)dateCreated) ? new Date(JellyTagUtils.parseDate(dateCreated).getTime()) : new Date();
        Date updated = StringUtils.isNotBlank((String)dateUpdated) ? new Date(JellyTagUtils.parseDate(dateUpdated).getTime()) : created;
        ApplicationUser authorUser = this.findUser(author);
        ApplicationUser updateAuthorUser = this.findUser(updateAuthor);
        Issue issue = this.findIssue(issueKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRoleService projectRoleService = (ProjectRoleService)ComponentAccessor.getComponent(ProjectRoleService.class);
        Long roleLevelId = null;
        if (roleLevel != null) {
            try {
                roleLevelId = new Long(roleLevel);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (roleLevelId == null) {
                ProjectRole projectRole = projectRoleService.getProjectRoleByName(authorUser == null ? null : authorUser.getDirectoryUser(), roleLevel, (ErrorCollection)errorCollection);
                if (projectRole != null) {
                    roleLevelId = projectRole.getId();
                } else {
                    throw new JellyTagException("ProjectRole level not found: " + roleLevel);
                }
            }
        }
        if (updated.getTime() < created.getTime()) {
            throw new JellyTagException("The updated date is earlier than the comment date, this is not allowed.");
        }
        if (!errorCollection.hasAnyErrors()) {
            CommentService commentService = (CommentService)ComponentAccessor.getComponent(CommentService.class);
            commentService.hasPermissionToCreate(authorUser, issue, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new JellyTagException(errorCollection.toString());
            }
            commentService.isValidAllCommentData(authorUser, issue, commentBody, grouplevel, roleLevelId == null ? null : roleLevelId.toString(), (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                throw new JellyTagException(errorCollection.toString());
            }
        } else {
            throw new JellyTagException(errorCollection.toString());
        }
        CommentManager commentManager = (CommentManager)ComponentAccessor.getComponent(CommentManager.class);
        commentManager.create(issue, authorUser, updateAuthorUser, commentBody, grouplevel, roleLevelId == null ? null : roleLevelId, created, updated, true, tweakIssueUpdateDate);
        this.invokeBody(xmlOutput);
    }

    private ApplicationUser findUser(String author) throws JellyTagException {
        ApplicationUser user = ComponentAccessor.getUserManager().getUserByName(author);
        if (user == null) {
            throw new JellyTagException("No such user exists: " + author);
        }
        return user;
    }

    private Issue findIssue(String issueKey) throws JellyTagException {
        MutableIssue issue;
        IssueManager issueManager = (IssueManager)ComponentAccessor.getComponent(IssueManager.class);
        try {
            issue = issueManager.getIssueObject(issueKey);
        }
        catch (RuntimeException e) {
            throw new JellyTagException("Error while trying to retrieve issue " + issueKey, (Throwable)e);
        }
        if (issue == null || issue.getGenericValue() == null) {
            throw new JellyTagException("The issue with key: " + issueKey + " does not exist");
        }
        return issue;
    }

    private String getPropertyByKey(String propertyKey) {
        String value = null;
        String valueRaw = (String)this.getProperties().get(propertyKey);
        if (StringUtils.isNotBlank((String)valueRaw)) {
            value = valueRaw;
        }
        return value;
    }
}

