/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.jira.action.screen.AddFieldToScreenUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.tag.JellyUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.opensymphony.util.TextUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;

public class AddFieldToScreen
extends JiraDynaBeanTagSupport {
    private static final String SCREEN = "screen";
    private static final String FIELD_ID = "fieldId";
    private static final String TAB_POS = "tab";
    private static final String FIELD_POS = "fieldPosition";
    private static final String DEFAULT_TAB_POS = "0";
    private AddFieldToScreenUtil addFieldToScreenUtil = (AddFieldToScreenUtil)ComponentAccessor.getComponentOfType(AddFieldToScreenUtil.class);
    private FieldScreenManager fieldScreenManager = (FieldScreenManager)ComponentAccessor.getComponentOfType(FieldScreenManager.class);
    private FieldScreen fieldScreen;
    private int tabPosition = -1;

    public void doTag(XMLOutput output) throws JellyTagException {
        this.validateParams();
        this.addFieldToScreenUtil.setFieldScreenId(this.getFieldScreen().getId());
        this.addFieldToScreenUtil.setTabPosition(this.getTabPosition());
        this.addFieldToScreenUtil.setFieldId(this.getFieldId());
        this.addFieldToScreenUtil.setFieldPosition(this.getFieldPosition());
        ErrorCollection errors = this.addFieldToScreenUtil.validate();
        if (errors != null && errors.hasAnyErrors()) {
            JellyUtils.processErrorCollection(errors);
        }
        this.addFieldToScreenUtil.execute();
    }

    private void validateParams() throws JellyTagException {
        if (!this.paramSpecified(SCREEN) || this.getFieldScreen() == null) {
            throw new MissingAttributeException(SCREEN);
        }
        if (!this.paramSpecified(FIELD_ID) || this.getFieldId() == null) {
            throw new MissingAttributeException(FIELD_ID);
        }
        if (!this.paramSpecified(TAB_POS)) {
            this.getProperties().put(TAB_POS, DEFAULT_TAB_POS);
        } else if (this.getTabPosition() < 0) {
            throw new JellyTagException(TAB_POS);
        }
        if (!this.paramSpecified(FIELD_POS) || !TextUtils.stringSet((String)this.getFieldPosition())) {
            this.getProperties().put(FIELD_POS, "");
        }
    }

    private boolean paramSpecified(String paramName) {
        return this.getProperties().containsKey(paramName);
    }

    public String[] getFieldId() {
        return new String[]{(String)this.getProperties().get(FIELD_ID)};
    }

    public int getTabPosition() {
        if (this.tabPosition < 0) {
            try {
                this.tabPosition = Integer.parseInt((String)this.getProperties().get(TAB_POS));
            }
            catch (NumberFormatException nfe) {
                String tabName = (String)this.getProperties().get(TAB_POS);
                for (FieldScreenTab tab : this.getFieldScreen().getTabs()) {
                    if (!tabName.equals(tab.getName())) continue;
                    this.tabPosition = tab.getPosition();
                }
            }
        }
        return this.tabPosition;
    }

    public String getFieldPosition() {
        return (String)this.getProperties().get(FIELD_POS);
    }

    public FieldScreenTab getTab() {
        if (this.getTabPosition() > -1) {
            return this.getFieldScreen().getTab(this.getTabPosition());
        }
        return null;
    }

    public FieldScreen getFieldScreen() {
        if (this.fieldScreen == null) {
            try {
                this.fieldScreen = this.fieldScreenManager.getFieldScreen(Long.decode((String)this.getProperties().get(SCREEN)));
            }
            catch (NumberFormatException nfe) {
                String screenName = (String)this.getProperties().get(SCREEN);
                for (FieldScreen fs : this.fieldScreenManager.getFieldScreens()) {
                    if (!screenName.equals(fs.getName())) continue;
                    this.fieldScreen = fs;
                }
            }
        }
        return this.fieldScreen;
    }
}

