/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.watchers;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueWatcherAddedEvent;
import com.atlassian.jira.event.issue.IssueWatcherDeletedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWatcherManager
implements WatcherManager {
    private static final Logger log = Logger.getLogger(DefaultWatcherManager.class);
    public static final String ASSOCIATION_TYPE = "WatchIssue";
    private final UserAssociationStore userAssociationStore;
    private final ApplicationProperties applicationProperties;
    private final IssueIndexManager indexManager;
    private final UserManager userManager;
    private final IssueFactory issueFactory;
    private final EventPublisher eventPublisher;
    private final IssueManager issueManager;

    public DefaultWatcherManager(UserAssociationStore userAssociationStore, ApplicationProperties applicationProperties, IssueIndexManager indexManager, UserManager userManager, IssueFactory issueFactory, EventPublisher eventPublisher, IssueManager issueManager) {
        this.userAssociationStore = userAssociationStore;
        this.applicationProperties = applicationProperties;
        this.indexManager = indexManager;
        this.userManager = userManager;
        this.issueFactory = issueFactory;
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
    }

    public void startWatching(User user, Issue issue) {
        this.updateWatch(true, ApplicationUsers.from((User)user), issue);
    }

    public void startWatching(ApplicationUser user, Issue issue) {
        this.updateWatch(true, user, issue);
    }

    public void startWatching(ApplicationUser user, Collection<Issue> issues) {
        for (Issue issue : issues) {
            this.updateWatch(true, user, issue, false);
        }
        this.reindex(issues);
    }

    public void startWatching(User user, GenericValue issueGV) {
        this.updateWatch(true, ApplicationUsers.from((User)user), (Issue)this.issueFactory.getIssueOrNull(issueGV));
    }

    public void stopWatching(String username, GenericValue issueGV) {
        this.updateWatch(false, this.userManager.getUserByNameEvenWhenUnknown(username), (Issue)this.issueFactory.getIssueOrNull(issueGV));
    }

    public void stopWatching(User user, Issue issue) {
        this.updateWatch(false, this.userManager.getUserByNameEvenWhenUnknown(user.getName()), issue);
    }

    public void stopWatching(ApplicationUser user, Issue issue) {
        this.updateWatch(false, user, issue);
    }

    public void stopWatching(ApplicationUser user, Collection<Issue> issues) {
        for (Issue issue : issues) {
            this.updateWatch(false, this.userManager.getUserByNameEvenWhenUnknown(user.getName()), issue, false);
        }
        this.reindex(issues);
    }

    public void stopWatching(User user, GenericValue issueGV) {
        this.updateWatch(false, ApplicationUsers.from((User)user), (Issue)this.issueFactory.getIssueOrNull(issueGV));
    }

    public List<String> getCurrentWatcherUsernames(Issue issue) throws DataAccessException {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue.getGenericValue());
    }

    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    public boolean isWatching(User user, Issue issue) {
        return this.isWatching(ApplicationUsers.from((User)user), issue);
    }

    public boolean isWatching(ApplicationUser user, Issue issue) {
        if (user == null) {
            return false;
        }
        Long watches = issue.getWatches();
        if (watches == null || watches == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, "Issue", issue.getId());
    }

    public boolean isWatching(User user, GenericValue issue) {
        if (user == null) {
            return false;
        }
        Long watches = issue.getLong("watches");
        if (watches == null || watches == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, "Issue", issue.getLong("id"));
    }

    public Collection<User> getCurrentWatchList(Issue issue, Locale userLocale) {
        return ApplicationUsers.toDirectoryUsers(this.getWatchers(issue, userLocale));
    }

    public List<ApplicationUser> getWatchers(Issue issue, Locale userLocale) {
        List<ApplicationUser> watchers = this.userAssociationStore.getUsersFromSink(ASSOCIATION_TYPE, issue.getGenericValue());
        Collections.sort(watchers, new ApplicationUserBestNameComparator(userLocale));
        return watchers;
    }

    public int getWatcherCount(Issue issue) {
        return this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, issue.getId()).size();
    }

    public Collection<String> getWatcherUserKeys(Issue issue) {
        return this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, issue.getId());
    }

    public List<String> getCurrentWatcherUsernames(GenericValue issue) throws DataAccessException {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue);
    }

    private boolean updateWatch(boolean addWatch, ApplicationUser user, Issue issue) {
        return this.updateWatch(addWatch, user, issue, true);
    }

    private boolean updateWatch(boolean addWatch, ApplicationUser user, Issue issue, boolean reindex) {
        if (this.validateUpdate(user, issue)) {
            try {
                if (addWatch) {
                    if (!this.isWatching(user, issue)) {
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        this.adjustWatchCount(issue.getGenericValue(), 1, reindex);
                        this.eventPublisher.publish((Object)new IssueWatcherAddedEvent(issue, user));
                        return true;
                    }
                } else if (this.isWatching(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user, issue);
                    this.adjustWatchCount(issue.getGenericValue(), -1, reindex);
                    this.eventPublisher.publish((Object)new IssueWatcherDeletedEvent(issue, user));
                    return true;
                }
            }
            catch (GenericEntityException e) {
                log.error((Object)"Error changing watch association", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean validateUpdate(ApplicationUser user, Issue issue) {
        if (issue == null) {
            log.error((Object)"You must specify an issue.");
            return false;
        }
        if (user == null) {
            log.error((Object)"You must specify a user.");
            return false;
        }
        return true;
    }

    private void adjustWatchCount(GenericValue originalIssue, int adjustValue, boolean reindex) throws GenericEntityException {
        long watches = this.recalculateWatches(originalIssue, adjustValue);
        Long issueId = originalIssue.getLong("id");
        GenericValue clonedIssue = (GenericValue)originalIssue.clone();
        clonedIssue.clear();
        clonedIssue.set("id", (Object)issueId);
        clonedIssue.set("watches", (Object)watches);
        clonedIssue.store();
        originalIssue.set("watches", (Object)watches);
        if (reindex) {
            GenericValue updatedIssue = this.issueManager.getIssue(issueId);
            this.reindex(updatedIssue);
        }
    }

    private long recalculateWatches(GenericValue issue, int adjustValue) {
        Long watches = issue.getLong("watches");
        if (watches == null) {
            watches = 0L;
        }
        if ((watches = Long.valueOf(watches + (long)adjustValue)) < 0L) {
            watches = 0L;
        }
        return watches;
    }

    public void removeAllWatchesForUser(User user) {
        Assertions.notNull((String)"User", (Object)user);
        this.removeAllWatchesForUser(ApplicationUsers.from((User)user));
    }

    public void removeAllWatchesForUser(ApplicationUser user) {
        Assertions.notNull((String)"User", (Object)user);
        List<GenericValue> watchedIssues = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        this.userAssociationStore.removeUserAssociationsFromUser(ASSOCIATION_TYPE, user, "Issue");
        for (GenericValue issue : watchedIssues) {
            this.reindex(issue);
            this.eventPublisher.publish((Object)new IssueWatcherDeletedEvent((Issue)this.issueFactory.getIssue(issue), user));
        }
    }

    private void reindex(GenericValue issue) {
        try {
            this.indexManager.reIndex((Issue)this.issueFactory.getIssue(issue), false, false);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    private void reindex(Collection<Issue> issues) {
        try {
            this.indexManager.reIndexIssueObjects(issues);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }
}

