/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.vote.VotedIssuesAccessor;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;

public class DefaultVotedIssuesAccessor
implements VotedIssuesAccessor {
    private final VoteManager voteManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory factory;

    public DefaultVotedIssuesAccessor(@Nonnull VoteManager voteManager, @Nonnull SearchProvider searchProvider, @Nonnull SearchProviderFactory factory) {
        this.voteManager = (VoteManager)Assertions.notNull((String)"voteManager", (Object)voteManager);
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.factory = (SearchProviderFactory)Assertions.notNull((String)"factory", (Object)factory);
    }

    public Iterable<Long> getVotedIssueIds(User voter, User searcher, VotedIssuesAccessor.Security security) {
        IssueIdCollector collector = new IssueIdCollector();
        Query query = DefaultVotedIssuesAccessor.getVoterQuery(voter);
        try {
            switch (security) {
                case OVERRIDE: {
                    this.searchProvider.searchOverrideSecurity(query, searcher, (Collector)collector);
                    break;
                }
                case RESPECT: {
                    this.searchProvider.search(query, searcher, (Collector)collector);
                }
            }
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return collector.getIds();
    }

    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    static Query getVoterQuery(User voter) {
        return JqlQueryBuilder.newBuilder().where().voterUser(voter.getName()).endWhere().buildQuery();
    }

    private class IssueIdCollector
    extends DocumentHitCollector {
        private final CollectionBuilder<String> issueIds;

        public IssueIdCollector() {
            super(DefaultVotedIssuesAccessor.this.factory.getSearcher("issues"));
            this.issueIds = CollectionBuilder.newBuilder();
        }

        public void collect(Document d) {
            this.issueIds.add((Object)d.get("issue_id"));
        }

        Iterable<Long> getIds() {
            return Transformed.list((List)this.issueIds.asList(), (Function)new Function<String, Long>(){

                public Long get(String input) {
                    return Long.valueOf(input);
                }
            });
        }
    }
}

