/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.thumbnail;

import com.atlassian.jira.issue.thumbnail.Dimensions;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class StreamingImageRenderer {
    public Dimensions renderThumbnail(InputStream inputStream, File thumbnailFile, int maxWidth, int maxHeight) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
        BufferedImage bi = this.scaleDown(iis, maxWidth, maxHeight);
        ImageIO.write((RenderedImage)bi, "png", thumbnailFile);
        return new Dimensions(bi.getWidth(), bi.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage scaleDown(ImageInputStream inputStream, int maxWidth, int maxHeight) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(inputStream);
        if (!readers.hasNext()) {
            throw new IOException("There is not ImageReader available for the given ImageInputStream");
        }
        ImageReader reader = readers.next();
        try {
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(inputStream);
            int ratio = this.maintainAspectRatio(new Dimension(reader.getWidth(0), reader.getHeight(0)), new Dimension(maxWidth, maxHeight));
            param.setSourceSubsampling(ratio, ratio, 0, 0);
            BufferedImage bufferedImage = reader.read(0, param);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    public int maintainAspectRatio(Dimension original, Dimension target) {
        if (original.getWidth() > target.getWidth() || original.getHeight() > target.getHeight()) {
            long ratioWidth = Math.round(original.getWidth() / target.getWidth());
            long ratioHeight = Math.round(original.getHeight() / target.getHeight());
            return (int)Math.max(ratioHeight, ratioWidth);
        }
        return 1;
    }
}

