/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;

public class OneDimensionalDocHitCollector
extends DocumentHitCollector {
    private final String luceneGroupField;
    private final Map result;

    public OneDimensionalDocHitCollector(String luceneGroupField, Map result, IndexSearcher searcher) {
        super(searcher);
        this.luceneGroupField = luceneGroupField;
        this.result = result;
    }

    public void collect(Document d) {
        String[] values = d.getValues(this.luceneGroupField);
        this.adjustMapForValues(this.result, values);
    }

    private void adjustMapForValues(Map map, String[] values) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            Integer count = (Integer)map.get(value);
            if (count == null) {
                count = new Integer(0);
            }
            map.put(value, new Integer(count + 1));
        }
    }
}

