/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.search.quicksearch.ComponentQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.CreatedQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.DueDateQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.FixForQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.IssueTypeQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ModifiableQuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.MyIssuesQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.OverdueQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.PriorityQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.RaisedInVersionQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ReporterQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ResolutionQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.StatusQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.UpdatedQuickSearchHandler;
import com.atlassian.jira.issue.search.util.QueryCreator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class DefaultQueryCreator
implements QueryCreator {
    private final List<QuickSearchHandler> queryHandlers = new ArrayList<QuickSearchHandler>();
    private ApplicationProperties applicationProperties;

    public DefaultQueryCreator(ProjectManager projectManager, ConstantsManager constantsManager, VersionManager versionManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, ProjectComponentManager projectComponentManager, DateTimeFormatterFactory dateTimeFormatterFactory, TimeZoneManager timeZoneManager, ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.queryHandlers.add(new ProjectQuickSearchHandler(projectManager, permissionManager, authenticationContext));
        this.queryHandlers.add(new IssueTypeQuickSearchHandler(constantsManager));
        this.queryHandlers.add(new StatusQuickSearchHandler(constantsManager));
        this.queryHandlers.add(new FixForQuickSearchHandler(versionManager, projectManager, permissionManager, authenticationContext));
        this.queryHandlers.add(new RaisedInVersionQuickSearchHandler(versionManager, projectManager, permissionManager, authenticationContext));
        this.queryHandlers.add(new ComponentQuickSearchHandler(projectComponentManager, projectManager, permissionManager, authenticationContext));
        this.queryHandlers.add(new MyIssuesQuickSearchHandler());
        this.queryHandlers.add(new OverdueQuickSearchHandler());
        this.queryHandlers.add(new ReporterQuickSearchHandler());
        this.queryHandlers.add(new ResolutionQuickSearchHandler(constantsManager));
        this.queryHandlers.add(new PriorityQuickSearchHandler(constantsManager));
        this.queryHandlers.add(new CreatedQuickSearchHandler(dateTimeFormatterFactory));
        this.queryHandlers.add(new UpdatedQuickSearchHandler(dateTimeFormatterFactory));
        this.queryHandlers.add(new DueDateQuickSearchHandler(timeZoneManager));
    }

    public String createQuery(String searchString) {
        if (searchString == null) {
            return "IssueNavigator.jspa?mode=show";
        }
        QuickSearchResult quickSearchResult = this.searchQuickSearch(searchString);
        String quickSearchQuery = quickSearchResult.getQueryString();
        String query = "IssueNavigator.jspa?reset=true&mode=show" + this.getDefaultQuery(quickSearchResult.getSearchInput()) + quickSearchQuery;
        if (TextUtils.stringSet((String)quickSearchQuery)) {
            query = query + "&usedQuickSearch=true&originalQuickSearchQuery=" + this.encode(searchString);
        }
        return query;
    }

    private QuickSearchResult searchQuickSearch(String searchString) {
        ModifiableQuickSearchResult quickSearchResult = new ModifiableQuickSearchResult(searchString);
        for (QuickSearchHandler quickSearchHandler : this.queryHandlers) {
            quickSearchHandler.modifySearchResult(quickSearchResult);
        }
        return quickSearchResult;
    }

    private String getDefaultQuery(String searchString) {
        if (TextUtils.stringSet((String)searchString)) {
            return "&text=" + this.encode(searchString);
        }
        return "";
    }

    private String encode(String searchString) {
        return JiraUrlCodec.encode((String)searchString, (String)this.applicationProperties.getEncoding(), (boolean)true);
    }
}

