/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.searchers.transformer.SearchInput;

public class VersionSearchInput
extends SearchInput {
    private VersionSearchInput(VersionInputType type, String value) {
        super(type, value);
    }

    public static VersionSearchInput noVersions() {
        return new VersionSearchInput(VersionInputType.NO_VERSION, null);
    }

    public static VersionSearchInput allUnreleased() {
        return new VersionSearchInput(VersionInputType.ALL_UNRELEASED, null);
    }

    public static VersionSearchInput allReleased() {
        return new VersionSearchInput(VersionInputType.ALL_RELEASED, null);
    }

    public static VersionSearchInput version(String value) {
        return new VersionSearchInput(VersionInputType.VERSION, value);
    }

    public boolean isNoVersion() {
        return VersionInputType.NO_VERSION.equals(this.type);
    }

    public boolean isAllUnreleased() {
        return VersionInputType.ALL_UNRELEASED.equals(this.type);
    }

    public boolean isAllReleased() {
        return VersionInputType.ALL_RELEASED.equals(this.type);
    }

    public boolean isVersion() {
        return VersionInputType.VERSION.equals(this.type);
    }

    private static class VersionInputType
    extends SearchInput.InputType {
        static final VersionInputType NO_VERSION = new VersionInputType("NO_VERSION");
        static final VersionInputType ALL_UNRELEASED = new VersionInputType("ALL_UNRELEASED");
        static final VersionInputType ALL_RELEASED = new VersionInputType("ALL_RELEASED");
        static final VersionInputType VERSION = new VersionInputType("VERSION");

        private VersionInputType(String name) {
            super(name);
        }
    }
}

