/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInput;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.ProjectConstant;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractProjectConstantsSearchInputTransformer<T extends ProjectConstant, I extends SearchInput>
implements SearchInputTransformer {
    private final String urlParameterName;
    protected final ClauseNames clauseNames;
    protected final JqlOperandResolver operandResolver;
    protected final NameResolver<T> nameResolver;
    private final NavigatorStructureChecker<T> navigatorStructureChecker;

    @VisibleForTesting
    AbstractProjectConstantsSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, NameResolver<T> nameResolver) {
        this(clauseNames, urlParameterName, operandResolver, nameResolver, new NavigatorStructureChecker(clauseNames, true, fieldFlagOperandRegistry, operandResolver));
    }

    AbstractProjectConstantsSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, JqlOperandResolver operandResolver, NameResolver<T> nameResolver, NavigatorStructureChecker<T> checker) {
        this.clauseNames = (ClauseNames)Assertions.notNull((String)"clauseNames", (Object)clauseNames);
        this.urlParameterName = urlParameterName;
        this.operandResolver = operandResolver;
        this.nameResolver = nameResolver;
        this.navigatorStructureChecker = checker;
    }

    public void populateFromParams(User user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        String[] params = actionParams.getValuesForKey(this.urlParameterName);
        LinkedHashSet values = Sets.newLinkedHashSet();
        if (params != null) {
            for (String param : params) {
                String[] parts = param.split(":", 2);
                values.add(this.parseInputParam(parts));
            }
        }
        fieldValuesHolder.put((Object)this.urlParameterName, (Object)values);
    }

    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }

    public void populateFromQuery(User user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        List<TerminalClause> clauses = this.getMatchingClauses(this.clauseNames.getJqlFieldNames(), query);
        LinkedHashSet values = Sets.newLinkedHashSet();
        for (TerminalClause clause : clauses) {
            this.parseOperand(clause.getOperand(), values);
        }
        fieldValuesHolder.put((Object)this.urlParameterName, (Object)values);
    }

    private List<TerminalClause> getMatchingClauses(Set<String> jqlClauseNames, Query query) {
        NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor(jqlClauseNames);
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)clauseVisitor);
            return clauseVisitor.getNamedClauses();
        }
        return Collections.emptyList();
    }

    private void parseOperand(Operand operand, Set<I> values) {
        if (operand instanceof EmptyOperand) {
            values.add(this.noValueInput());
        } else if (operand instanceof SingleValueOperand) {
            this.parseSingleValueOperand((SingleValueOperand)operand, values);
        } else if (operand instanceof FunctionOperand) {
            this.parseFunctionOperand((FunctionOperand)operand, values);
        } else if (operand instanceof MultiValueOperand) {
            MultiValueOperand multiValueOperand = (MultiValueOperand)operand;
            for (Operand value : multiValueOperand.getValues()) {
                this.parseOperand(value, values);
            }
        }
    }

    private void parseSingleValueOperand(SingleValueOperand operand, Set<I> values) {
        String value;
        block7: {
            value = null;
            if (operand.getStringValue() != null) {
                try {
                    Long id = Long.valueOf(operand.getStringValue());
                    T object = this.findById(id);
                    if (object != null) {
                        value = object.getName();
                        if (this.nameResolver.nameExists(operand.getStringValue())) {
                            values.add(this.inputValue(operand.getStringValue()));
                        }
                        break block7;
                    }
                    value = operand.getStringValue();
                }
                catch (NumberFormatException e) {
                    value = operand.getStringValue();
                }
            } else if (operand.getLongValue() != null) {
                T object = this.findById(operand.getLongValue());
                value = object != null ? object.getName() : String.valueOf(operand.getLongValue());
            }
        }
        values.add(this.inputValue(value));
    }

    public Clause getSearchClause(User user, FieldValuesHolder fieldValuesHolder) {
        ArrayList operands = Lists.newArrayList();
        Collection values = (Collection)fieldValuesHolder.get((Object)this.urlParameterName);
        boolean containsList = false;
        if (values != null) {
            for (SearchInput value : values) {
                Operand operand = this.parseInputValue(value);
                operands.add(operand);
                containsList = this.operandResolver.isListOperand(operand);
            }
        }
        if (operands.isEmpty()) {
            return null;
        }
        if (operands.size() == 1) {
            return new TerminalClauseImpl(this.clauseNames.getPrimaryName(), containsList ? Operator.IN : Operator.EQUALS, (Operand)operands.iterator().next());
        }
        return new TerminalClauseImpl(this.clauseNames.getPrimaryName(), Operator.IN, (Operand)new MultiValueOperand((Collection)operands));
    }

    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        return this.navigatorStructureChecker.checkSearchRequest(query, searchContext) && this.checkValidValues(searcher, query);
    }

    private boolean checkValidValues(User searcher, Query query) {
        SimpleNavigatorCollectorVisitor collector = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)collector);
            if (collector.getClauses().size() == 1) {
                TerminalClause terminalClause = (TerminalClause)collector.getClauses().get(0);
                Operand operand = terminalClause.getOperand();
                return this.checkValidValues(searcher, operand, terminalClause);
            }
        }
        return true;
    }

    private boolean checkValidValues(User searcher, Operand operand, TerminalClause terminalClause) {
        if (this.operandResolver.isFunctionOperand(operand) || this.operandResolver.isEmptyOperand(operand)) {
            return true;
        }
        if (this.operandResolver.isListOperand(operand)) {
            MultiValueOperand listOperand = (MultiValueOperand)operand;
            for (Operand childOperand : listOperand.getValues()) {
                if (this.checkValidValues(searcher, childOperand, terminalClause)) continue;
                return false;
            }
            return true;
        }
        List values = this.operandResolver.getValues(searcher, operand, terminalClause);
        for (QueryLiteral value : values) {
            if (this.checkClauseValuesForBasic(value)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private T findById(Long id) {
        return (T)((ProjectConstant)this.nameResolver.get(id));
    }

    @Nonnull
    abstract I parseInputParam(String[] var1);

    @Nonnull
    abstract I inputValue(String var1);

    @Nonnull
    abstract I noValueInput();

    abstract void parseFunctionOperand(FunctionOperand var1, Set<I> var2);

    @Nonnull
    abstract Operand parseInputValue(I var1);

    abstract boolean checkClauseValuesForBasic(QueryLiteral var1);
}

